/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.VerticesArgs;
import org.apache.hugegraph.util.E;

public class CrosspointsRequest {
    @JsonProperty(value="sources")
    private VerticesArgs sources = null;
    @JsonProperty(value="path_patterns")
    private List<PathPattern> pathPatterns = new ArrayList<PathPattern>();
    @JsonProperty(value="capacity")
    private long capacity = 10000000L;
    @JsonProperty(value="limit")
    private long limit = 10000L;
    @JsonProperty(value="with_path")
    public boolean withPath = false;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;
    @JsonProperty(value="with_edge")
    public boolean withEdge = false;

    private CrosspointsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("CrosspointsRequest{sourceVertex=%s,pathPatterns=%s,capacity=%s,limit=%s,withPath=%s,withVertex=%s,withEdge=%s}", this.sources, this.pathPatterns, this.capacity, this.limit, this.withPath, this.withVertex, this.withEdge);
    }

    public static class Step {
        @JsonProperty(value="direction")
        private String direction = null;
        @JsonProperty(value="labels")
        private List<String> labels = new ArrayList<String>();
        @JsonProperty(value="properties")
        private Map<String, Object> properties = new HashMap<String, Object>();
        @JsonProperty(value="degree")
        private long degree = 10000L;

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%s,degree=%s}", this.direction, this.labels, this.properties, this.degree);
        }

        public static class Builder {
            private final Step step = new Step();

            private Builder() {
            }

            public Builder direction(Direction direction) {
                this.step.direction = direction.toString();
                return this;
            }

            public Builder labels(List<String> labels) {
                this.step.labels = labels;
                return this;
            }

            public Builder labels(String label) {
                this.step.labels.add(label);
                return this;
            }

            public Builder properties(Map<String, Object> properties) {
                this.step.properties = properties;
                return this;
            }

            public Builder properties(String key, Object value) {
                this.step.properties.put(key, value);
                return this;
            }

            public Builder degree(long degree) {
                TraversersAPI.checkDegree(degree);
                this.step.degree = degree;
                return this;
            }

            private Step build() {
                TraversersAPI.checkDegree(this.step.degree);
                return this.step;
            }
        }
    }

    public static class PathPattern {
        @JsonProperty(value="steps")
        private List<Step> steps = new ArrayList<Step>();

        private PathPattern() {
        }

        public static class Builder {
            private final PathPattern pathPattern = new PathPattern();
            private final List<Step.Builder> stepBuilders = new ArrayList<Step.Builder>();

            private Builder() {
            }

            public Step.Builder steps() {
                Step.Builder builder = new Step.Builder();
                this.stepBuilders.add(builder);
                return builder;
            }

            private PathPattern build() {
                for (Step.Builder builder : this.stepBuilders) {
                    this.pathPattern.steps.add(builder.build());
                }
                E.checkArgument((this.pathPattern.steps != null && !this.pathPattern.steps.isEmpty() ? 1 : 0) != 0, (String)"Steps of path pattern can't be empty", (Object[])new Object[0]);
                return this.pathPattern;
            }
        }
    }

    public static class Builder {
        private final CrosspointsRequest request = new CrosspointsRequest();
        private final VerticesArgs.Builder sourcesBuilder = VerticesArgs.builder();
        private final List<PathPattern.Builder> pathPatternBuilders = new ArrayList<PathPattern.Builder>();

        private Builder() {
        }

        public VerticesArgs.Builder sources() {
            return this.sourcesBuilder;
        }

        public PathPattern.Builder pathPatterns() {
            PathPattern.Builder builder = new PathPattern.Builder();
            this.pathPatternBuilders.add(builder);
            return builder;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withPath(boolean withPath) {
            this.request.withPath = withPath;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public Builder withEdge(boolean withEdge) {
            this.request.withEdge = withEdge;
            return this;
        }

        public CrosspointsRequest build() {
            this.request.sources = this.sourcesBuilder.build();
            for (PathPattern.Builder builder : this.pathPatternBuilders) {
                this.request.pathPatterns.add(builder.build());
            }
            E.checkArgument((this.request.sources != null ? 1 : 0) != 0, (String)"Source vertices can't be null", (Object[])new Object[0]);
            E.checkArgument((this.request.pathPatterns != null && !this.request.pathPatterns.isEmpty() ? 1 : 0) != 0, (String)"Steps can't be null or empty", (Object[])new Object[0]);
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

