/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ActivityCorrelator {
    private static Map<Long, ActivityId> activityIdTlsMap = new ConcurrentHashMap<Long, ActivityId>();

    static void cleanupActivityId() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (activityIdTlsMap.containsKey(uniqueThreadId)) {
            activityIdTlsMap.remove(uniqueThreadId);
        }
    }

    static ActivityId getCurrent() {
        long uniqueThreadId = Thread.currentThread().getId();
        if (!activityIdTlsMap.containsKey(uniqueThreadId)) {
            activityIdTlsMap.put(uniqueThreadId, new ActivityId());
        }
        return activityIdTlsMap.get(uniqueThreadId);
    }

    static ActivityId getNext() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.increment();
        return activityId;
    }

    static void setCurrentActivityIdSentFlag() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.setSentFlag();
    }

    private ActivityCorrelator() {
    }
}

