/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMetricsAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(GraphMetricsAPI.class);
    private static final String GRAPH_METRICS_PATH = "graphspaces/%s/graphs/%s/%s";
    private final String elementCountPath = "elementcount";
    private final String typeCountPath = "typecount";
    private final String evPath;
    private final String evPathByMonth;
    private final String typePath;
    private final String typePathByMonth;

    public GraphMetricsAPI(RestClient client, String graphSpace, String graph) {
        super(client);
        this.path(GRAPH_METRICS_PATH, graphSpace, graph, this.type());
        this.evPath = String.format("%s/%s", this.path(), "elementcount");
        this.evPathByMonth = String.format("%s/%s/month", this.path(), "elementcount");
        this.typePath = String.format("%s/%s", this.path(), "typecount");
        this.typePathByMonth = String.format("%s/%s/month", this.path(), "typecount");
    }

    @Override
    protected String type() {
        return HugeType.METRICS.string();
    }

    public long createEVCountJob() {
        RestResult result = this.client.post(this.evPath, ImmutableMap.of());
        return ((Number)((Map)result.readObject(Map.class)).get("task_id")).longValue();
    }

    public ElementCount getEVCount(String dateStr) {
        try {
            RestResult result = this.client.get(this.evPath, dateStr);
            return (ElementCount)result.readObject(ElementCount.class);
        }
        catch (ServerException e) {
            log.warn(e.exception());
            return null;
        }
    }

    public Map<String, ElementCount> getEVCountByMonth(String monthStr) {
        HashMap<String, ElementCount> result = new HashMap<String, ElementCount>();
        RestResult resp = this.client.get(this.evPathByMonth, monthStr);
        Map elementCounts = (Map)resp.readObject(Map.class);
        for (Map.Entry entry : elementCounts.entrySet()) {
            String strDate = (String)entry.getKey();
            Object elementCountMap = entry.getValue();
            ElementCount elementCount = JsonUtil.fromJson(JsonUtil.toJson(elementCountMap), ElementCount.class);
            result.put(strDate, elementCount);
        }
        return result;
    }

    public long createTypeCountJob() {
        this.client.post(this.typePath, ImmutableMap.of());
        return 0L;
    }

    public TypeCount getTypeCount(String dateStr) {
        try {
            RestResult result = this.client.get(this.typePath, dateStr);
            return (TypeCount)result.readObject(TypeCount.class);
        }
        catch (ServerException e) {
            log.warn(e.exception());
            return null;
        }
    }

    public TypeCounts getTypeCounts(String from, String to) {
        try {
            RestResult result = this.client.get(this.typePath, (Map<String, Object>)ImmutableMap.of((Object)"from", (Object)from, (Object)"to", (Object)to));
            return (TypeCounts)result.readObject(TypeCounts.class);
        }
        catch (ServerException e) {
            log.warn(e.exception());
            return null;
        }
    }

    public Map<String, TypeCount> getTypeCountByMonth(String monthStr) {
        HashMap<String, TypeCount> result = new HashMap<String, TypeCount>();
        RestResult resp = this.client.get(this.typePathByMonth, monthStr);
        Map typeCounts = (Map)resp.readObject(Map.class);
        for (Map.Entry entry : typeCounts.entrySet()) {
            String strDate = (String)entry.getKey();
            Object typeCountMap = entry.getValue();
            TypeCount typeCount = JsonUtil.fromJson(JsonUtil.toJson(typeCountMap), TypeCount.class);
            result.put(strDate, typeCount);
        }
        return result;
    }

    public static class TypeCount {
        @JsonProperty(value="datetime")
        String datetime;
        @JsonProperty(value="vertices")
        Map<String, Long> vertices;
        @JsonProperty(value="edges")
        Map<String, Long> edges;
        @JsonProperty(value="schemas")
        Map<String, Long> schemas;

        public static TypeCountBuilder builder() {
            return new TypeCountBuilder();
        }

        public String getDatetime() {
            return this.datetime;
        }

        public Map<String, Long> getVertices() {
            return this.vertices;
        }

        public Map<String, Long> getEdges() {
            return this.edges;
        }

        public Map<String, Long> getSchemas() {
            return this.schemas;
        }

        @JsonProperty(value="datetime")
        public void setDatetime(String datetime) {
            this.datetime = datetime;
        }

        @JsonProperty(value="vertices")
        public void setVertices(Map<String, Long> vertices) {
            this.vertices = vertices;
        }

        @JsonProperty(value="edges")
        public void setEdges(Map<String, Long> edges) {
            this.edges = edges;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(Map<String, Long> schemas) {
            this.schemas = schemas;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCount)) {
                return false;
            }
            TypeCount other = (TypeCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$datetime = this.getDatetime();
            String other$datetime = other.getDatetime();
            if (this$datetime == null ? other$datetime != null : !this$datetime.equals(other$datetime)) {
                return false;
            }
            Map<String, Long> this$vertices = this.getVertices();
            Map<String, Long> other$vertices = other.getVertices();
            if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
                return false;
            }
            Map<String, Long> this$edges = this.getEdges();
            Map<String, Long> other$edges = other.getEdges();
            if (this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges)) {
                return false;
            }
            Map<String, Long> this$schemas = this.getSchemas();
            Map<String, Long> other$schemas = other.getSchemas();
            return !(this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $datetime = this.getDatetime();
            result = result * 59 + ($datetime == null ? 43 : $datetime.hashCode());
            Map<String, Long> $vertices = this.getVertices();
            result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
            Map<String, Long> $edges = this.getEdges();
            result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
            Map<String, Long> $schemas = this.getSchemas();
            result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
            return result;
        }

        public String toString() {
            return "GraphMetricsAPI.TypeCount(datetime=" + this.getDatetime() + ", vertices=" + this.getVertices() + ", edges=" + this.getEdges() + ", schemas=" + this.getSchemas() + ")";
        }

        public TypeCount(String datetime, Map<String, Long> vertices, Map<String, Long> edges, Map<String, Long> schemas) {
            this.datetime = datetime;
            this.vertices = vertices;
            this.edges = edges;
            this.schemas = schemas;
        }

        public TypeCount() {
        }

        public static class TypeCountBuilder {
            private String datetime;
            private Map<String, Long> vertices;
            private Map<String, Long> edges;
            private Map<String, Long> schemas;

            TypeCountBuilder() {
            }

            @JsonProperty(value="datetime")
            public TypeCountBuilder datetime(String datetime) {
                this.datetime = datetime;
                return this;
            }

            @JsonProperty(value="vertices")
            public TypeCountBuilder vertices(Map<String, Long> vertices) {
                this.vertices = vertices;
                return this;
            }

            @JsonProperty(value="edges")
            public TypeCountBuilder edges(Map<String, Long> edges) {
                this.edges = edges;
                return this;
            }

            @JsonProperty(value="schemas")
            public TypeCountBuilder schemas(Map<String, Long> schemas) {
                this.schemas = schemas;
                return this;
            }

            public TypeCount build() {
                return new TypeCount(this.datetime, this.vertices, this.edges, this.schemas);
            }

            public String toString() {
                return "GraphMetricsAPI.TypeCount.TypeCountBuilder(datetime=" + this.datetime + ", vertices=" + this.vertices + ", edges=" + this.edges + ", schemas=" + this.schemas + ")";
            }
        }
    }

    public static class TypeCounts {
        @JsonProperty(value="type_counts")
        Map<String, TypeCount> typeCounts;

        public static TypeCountsBuilder builder() {
            return new TypeCountsBuilder();
        }

        public Map<String, TypeCount> getTypeCounts() {
            return this.typeCounts;
        }

        @JsonProperty(value="type_counts")
        public void setTypeCounts(Map<String, TypeCount> typeCounts) {
            this.typeCounts = typeCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCounts)) {
                return false;
            }
            TypeCounts other = (TypeCounts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, TypeCount> this$typeCounts = this.getTypeCounts();
            Map<String, TypeCount> other$typeCounts = other.getTypeCounts();
            return !(this$typeCounts == null ? other$typeCounts != null : !((Object)this$typeCounts).equals(other$typeCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeCounts;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, TypeCount> $typeCounts = this.getTypeCounts();
            result = result * 59 + ($typeCounts == null ? 43 : ((Object)$typeCounts).hashCode());
            return result;
        }

        public String toString() {
            return "GraphMetricsAPI.TypeCounts(typeCounts=" + this.getTypeCounts() + ")";
        }

        public TypeCounts(Map<String, TypeCount> typeCounts) {
            this.typeCounts = typeCounts;
        }

        public TypeCounts() {
        }

        public static class TypeCountsBuilder {
            private Map<String, TypeCount> typeCounts;

            TypeCountsBuilder() {
            }

            @JsonProperty(value="type_counts")
            public TypeCountsBuilder typeCounts(Map<String, TypeCount> typeCounts) {
                this.typeCounts = typeCounts;
                return this;
            }

            public TypeCounts build() {
                return new TypeCounts(this.typeCounts);
            }

            public String toString() {
                return "GraphMetricsAPI.TypeCounts.TypeCountsBuilder(typeCounts=" + this.typeCounts + ")";
            }
        }
    }

    public static class ElementCount {
        String datetime;
        long vertices;
        long edges;

        public String getDatetime() {
            return this.datetime;
        }

        public long getVertices() {
            return this.vertices;
        }

        public long getEdges() {
            return this.edges;
        }

        public void setDatetime(String datetime) {
            this.datetime = datetime;
        }

        public void setVertices(long vertices) {
            this.vertices = vertices;
        }

        public void setEdges(long edges) {
            this.edges = edges;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementCount)) {
                return false;
            }
            ElementCount other = (ElementCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$datetime = this.getDatetime();
            String other$datetime = other.getDatetime();
            if (this$datetime == null ? other$datetime != null : !this$datetime.equals(other$datetime)) {
                return false;
            }
            if (this.getVertices() != other.getVertices()) {
                return false;
            }
            return this.getEdges() == other.getEdges();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElementCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $datetime = this.getDatetime();
            result = result * 59 + ($datetime == null ? 43 : $datetime.hashCode());
            long $vertices = this.getVertices();
            result = result * 59 + (int)($vertices >>> 32 ^ $vertices);
            long $edges = this.getEdges();
            result = result * 59 + (int)($edges >>> 32 ^ $edges);
            return result;
        }

        public String toString() {
            return "GraphMetricsAPI.ElementCount(datetime=" + this.getDatetime() + ", vertices=" + this.getVertices() + ", edges=" + this.getEdges() + ")";
        }
    }
}

