/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.PathWithMeasure;
import org.apache.hugegraph.structure.traverser.PathsRequest;
import org.apache.hugegraph.structure.traverser.PathsWithVertices;

public class PathsAPI
extends TraversersAPI {
    public PathsAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "paths";
    }

    public PathWithMeasure get(Object sourceId, Object targetId, Direction direction, String label, int maxDepth, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        PathsAPI.checkPositive(maxDepth, "Max depth of path");
        PathsAPI.checkDegree(degree);
        PathsAPI.checkCapacity(capacity);
        PathsAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", maxDepth);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return (PathWithMeasure)result.readObject(PathWithMeasure.class);
    }

    public PathsWithVertices post(PathsRequest request) {
        this.client.checkApiVersion("0.58", "paths with property filter");
        RestResult result = this.client.post(this.path(), request);
        return (PathsWithVertices)result.readObject(PathsWithVertices.class);
    }
}

