/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver.factory;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.factory.DefaultHugeClientFactory;
import org.apache.hugegraph.pd.client.DiscoveryClient;
import org.apache.hugegraph.pd.client.DiscoveryClientImpl;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PDHugeClientFactory {
    private static final Logger LOG = Log.logger(PDHugeClientFactory.class);
    public static final String DEFAULT_GRAPHSPACE = "DEFAULT";
    public static final String DEFAULT_SERVICE = "DEFAULT";
    public static final String NAME = "hg";
    public static final String TOKEN = "$2a$04$i10KooNg6wLvIPVDh909n.RBYlZ/4pJo978nFK86nrqQiGIKV4UGS";
    protected static final String SERVICE_VERSION = "1.0.0";
    protected final String pdAddrs;
    protected final RouteType type;
    protected final DiscoveryClient client;

    public PDHugeClientFactory(String pdAddrs) {
        this(pdAddrs, null);
    }

    public PDHugeClientFactory(String pdAddrs, String type) {
        this.pdAddrs = pdAddrs;
        this.type = type != null ? RouteType.valueOf(type) : RouteType.BOTH;
        PDConfig pdConfig = PDConfig.of((String)pdAddrs);
        this.client = DiscoveryClientImpl.newBuilder().setCenterAddress(pdAddrs).build();
    }

    public HugeClient createUnauthClient(String cluster, String graphSpace, String graph) {
        E.checkArgument((cluster != null ? 1 : 0) != 0, (String)"create unauth client: cluster must not null", (Object[])new Object[0]);
        return this.createUnauthClient(cluster, graphSpace, graph, 60);
    }

    public HugeClient createUnauthClient(String cluster, String graphSpace, String graph, int timeout) {
        E.checkArgument((cluster != null ? 1 : 0) != 0, (String)"create unauth client: cluster must not null", (Object[])new Object[0]);
        return this.createClient(cluster, graphSpace, graph, null, null, null, timeout);
    }

    public HugeClient createAuthClient(String cluster, String graphSpace, String graph, String token, String username, String password) {
        return this.createAuthClient(cluster, graphSpace, graph, token, username, password, 60);
    }

    public HugeClient createAuthClient(String cluster, String graphSpace, String graph, String token, String username, String password, int timeout) {
        E.checkArgument((cluster != null ? 1 : 0) != 0, (String)"create auth client: cluster must not null", (Object[])new Object[0]);
        E.checkArgument((token != null || username != null && password != null ? 1 : 0) != 0, (String)"create auth client: token must not null or username/password must not null", (Object[])new Object[0]);
        return this.createClient(cluster, graphSpace, graph, token, username, password, timeout);
    }

    protected HugeClient createClient(String cluster, String graphSpace, String graph, String token, String username, String password, int timeout) {
        List<String> urls = this.getAutoURLs(cluster, graphSpace, graph);
        DefaultHugeClientFactory defaultFactory = new DefaultHugeClientFactory(urls.toArray(new String[0]));
        int r = (int)Math.floor(Math.random() * (double)urls.size());
        String address = urls.get(r);
        if (!address.startsWith("http")) {
            address = "http://" + address;
        }
        HugeClient client = HugeClient.builder(address, graphSpace, graph).configToken(token).configUser(username, password).configTimeout(timeout).build();
        return client;
    }

    public List<String> getAutoURLs(String cluster, String graphSpace, String service) {
        List<String> urls = null;
        if (StringUtils.isNotEmpty((String)graphSpace)) {
            if (StringUtils.isNotEmpty((String)service)) {
                urls = this.getURLs(cluster, graphSpace, service);
            }
            if (CollectionUtils.isNotEmpty(urls)) {
                return urls;
            }
            urls = this.getURLs(cluster, graphSpace, null);
            if (CollectionUtils.isNotEmpty(urls)) {
                return urls;
            }
        }
        urls = this.getURLs(cluster, "DEFAULT", "DEFAULT");
        return urls;
    }

    public List<String> getURLs(String cluster, String graphSpace, String service) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((String)graphSpace), (String)"list urls error, cluster must not null", (Object[])new Object[0]);
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)graphSpace)) {
            configs.put("GRAPHSPACE", graphSpace);
        }
        if (StringUtils.isNotEmpty((String)service)) {
            configs.put("SERVICE_NAME", service);
        }
        if (!RouteType.BOTH.equals((Object)this.type)) {
            configs.put("REGISTER_TYPE", this.type.name());
        }
        Query query = Query.newBuilder().setAppName(cluster).putAllLabels(configs).build();
        NodeInfos nodeInfos = this.client.getNodeInfos(query);
        List<String> urls = nodeInfos.getInfoList().stream().map(nodeInfo -> nodeInfo.getAddress()).collect(Collectors.toList());
        return urls;
    }

    protected List<String> getURLsWithConfig(String cluster, Map<String, String> configs) {
        if (null == configs) {
            configs = ImmutableMap.of();
        }
        Query query = Query.newBuilder().setAppName(cluster).setVersion(SERVICE_VERSION).putAllLabels((Map)configs).build();
        NodeInfos nodeInfos = this.client.getNodeInfos(query);
        List<String> urls = nodeInfos.getInfoList().stream().map(nodeInfo -> nodeInfo.getAddress()).collect(Collectors.toList());
        return urls;
    }

    public void close() {
        this.client.close();
    }

    public static enum RouteType {
        BOTH,
        NODE_PORT,
        DDS;

    }
}

