/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.entity.enums.LoadStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.loader.HugeGraphLoader;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.hugegraph.util.SerializeUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@TableName(value="load_task", autoResultMap=true)
public class LoadTask
implements Runnable {
    private static final Logger log = LogManager.getLogger(LoadTask.class);
    @TableField(exist=false)
    @JsonIgnore
    private final transient Lock lock = new ReentrantLock();
    @TableField(exist=false)
    @JsonIgnore
    private volatile transient HugeGraphLoader loader;
    @TableField(exist=false)
    @JsonIgnore
    private volatile transient boolean finished;
    @TableId(type=IdType.AUTO)
    @MergeProperty(useNew=false)
    @JsonProperty(value="id")
    private Integer id;
    @TableField(value="conn_id")
    @MergeProperty
    @JsonProperty(value="conn_id")
    private Integer connId;
    @TableField(value="job_id")
    @MergeProperty
    @JsonProperty(value="job_id")
    private Integer jobId;
    @TableField(value="file_id")
    @MergeProperty
    @JsonProperty(value="file_id")
    private Integer fileId;
    @TableField(value="file_name")
    @MergeProperty
    @JsonProperty(value="file_name")
    private String fileName;
    @TableField(value="options", typeHandler=JacksonTypeHandler.class)
    @MergeProperty
    @JsonProperty(value="options", access=JsonProperty.Access.WRITE_ONLY)
    private LoadOptions options;
    @TableField(value="vertices", typeHandler=JacksonTypeHandler.class)
    @MergeProperty
    @JsonProperty(value="vertices")
    private Set<String> vertices;
    @TableField(value="edges", typeHandler=JacksonTypeHandler.class)
    @MergeProperty
    @JsonProperty(value="edges")
    private Set<String> edges;
    @TableField(value="file_total_lines")
    @MergeProperty
    @JsonProperty(value="file_total_lines")
    private Long fileTotalLines;
    @TableField(value="load_status")
    @MergeProperty
    @JsonProperty(value="status")
    private volatile LoadStatus status;
    @TableField(value="file_read_lines")
    @MergeProperty
    @JsonProperty(value="file_read_lines")
    private Long fileReadLines;
    @TableField(value="last_duration")
    @MergeProperty
    @JsonProperty(value="last_duration")
    @JsonSerialize(using=SerializeUtil.DurationSerializer.class)
    private Long lastDuration;
    @TableField(value="curr_duration")
    @MergeProperty
    @JsonProperty(value="curr_duration")
    @JsonSerialize(using=SerializeUtil.DurationSerializer.class)
    private Long currDuration;
    @MergeProperty(useNew=false)
    @JsonProperty(value="create_time")
    private Date createTime;

    public LoadTask(LoadOptions options, GraphConnection connection, FileMapping mapping) {
        this.finished = false;
        this.id = null;
        this.connId = connection.getId();
        this.jobId = mapping.getJobId();
        this.fileId = mapping.getId();
        this.fileName = mapping.getName();
        this.options = options;
        this.vertices = mapping.getVertexMappingLabels();
        this.edges = mapping.getEdgeMappingLabels();
        this.fileTotalLines = mapping.getTotalLines();
        this.status = LoadStatus.RUNNING;
        this.fileReadLines = 0L;
        this.lastDuration = 0L;
        this.currDuration = 0L;
        this.createTime = HubbleUtil.nowDate();
    }

    @Override
    public void run() {
        boolean noError;
        Ex.check(this.options != null, "The load options shouldn't be null", new Object[0]);
        log.info("LoadTask is start running : {}", (Object)this.id);
        this.loader = new HugeGraphLoader(this.options);
        try {
            noError = this.loader.load();
        }
        catch (Throwable e) {
            noError = false;
            log.error("Run task {} failed", (Object)this.id, (Object)e);
        }
        this.lock.lock();
        try {
            if (this.status.inRunning()) {
                this.status = noError ? LoadStatus.SUCCEED : LoadStatus.FAILED;
            }
            this.fileReadLines = this.context().newProgress().totalInputRead();
            this.lastDuration = this.lastDuration + this.context().summary().totalTime();
            this.currDuration = 0L;
        }
        finally {
            this.finished = true;
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void stop() {
        this.context().stopLoading();
        while (!this.finished) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.loader = null;
        log.info("LoadTask {} stopped", (Object)this.id);
    }

    public LoadContext context() {
        Ex.check(this.loader != null, "loader shouldn't be null", new Object[0]);
        return this.loader.context();
    }

    @JsonProperty(value="load_progress")
    public float getLoadProgress() {
        if (this.fileTotalLines == null || this.fileTotalLines == 0L) {
            return 0.0f;
        }
        Ex.check(this.fileTotalLines >= this.fileReadLines, "The file total lines must be >= read lines, but got total lines %s, read lines %s", this.fileTotalLines, this.fileReadLines);
        float actualProgress = (float)this.fileReadLines.longValue() / (float)this.fileTotalLines.longValue();
        return (float)((int)(actualProgress * 10000.0f)) / 100.0f;
    }

    @JsonProperty(value="duration")
    @JsonSerialize(using=SerializeUtil.DurationSerializer.class)
    public Long getDuration() {
        this.lock.lock();
        try {
            Long l = this.lastDuration + this.currDuration;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @JsonProperty(value="load_rate")
    public String getLoadRate() {
        float rate;
        long readLines = this.fileReadLines;
        long duration = this.getDuration();
        if (readLines == 0L || duration == 0L) {
            rate = 0.0f;
        } else {
            rate = (float)readLines * 1000.0f / (float)duration;
            rate = (float)Math.round(rate * 1000.0f) / 1000.0f;
        }
        return String.format("%s/s", Float.valueOf(rate));
    }

    public static LoadTaskBuilder builder() {
        return new LoadTaskBuilder();
    }

    public Lock getLock() {
        return this.lock;
    }

    public HugeGraphLoader getLoader() {
        return this.loader;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getConnId() {
        return this.connId;
    }

    public Integer getJobId() {
        return this.jobId;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public LoadOptions getOptions() {
        return this.options;
    }

    public Set<String> getVertices() {
        return this.vertices;
    }

    public Set<String> getEdges() {
        return this.edges;
    }

    public Long getFileTotalLines() {
        return this.fileTotalLines;
    }

    public LoadStatus getStatus() {
        return this.status;
    }

    public Long getFileReadLines() {
        return this.fileReadLines;
    }

    public Long getLastDuration() {
        return this.lastDuration;
    }

    public Long getCurrDuration() {
        return this.currDuration;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setLoader(HugeGraphLoader loader) {
        this.loader = loader;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="conn_id")
    public void setConnId(Integer connId) {
        this.connId = connId;
    }

    @JsonProperty(value="job_id")
    public void setJobId(Integer jobId) {
        this.jobId = jobId;
    }

    @JsonProperty(value="file_id")
    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    @JsonProperty(value="file_name")
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonProperty(value="options", access=JsonProperty.Access.WRITE_ONLY)
    public void setOptions(LoadOptions options) {
        this.options = options;
    }

    @JsonProperty(value="vertices")
    public void setVertices(Set<String> vertices) {
        this.vertices = vertices;
    }

    @JsonProperty(value="edges")
    public void setEdges(Set<String> edges) {
        this.edges = edges;
    }

    @JsonProperty(value="file_total_lines")
    public void setFileTotalLines(Long fileTotalLines) {
        this.fileTotalLines = fileTotalLines;
    }

    @JsonProperty(value="status")
    public void setStatus(LoadStatus status) {
        this.status = status;
    }

    @JsonProperty(value="file_read_lines")
    public void setFileReadLines(Long fileReadLines) {
        this.fileReadLines = fileReadLines;
    }

    @JsonProperty(value="last_duration")
    public void setLastDuration(Long lastDuration) {
        this.lastDuration = lastDuration;
    }

    @JsonProperty(value="curr_duration")
    public void setCurrDuration(Long currDuration) {
        this.currDuration = currDuration;
    }

    @JsonProperty(value="create_time")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadTask)) {
            return false;
        }
        LoadTask other = (LoadTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$connId = this.getConnId();
        Integer other$connId = other.getConnId();
        if (this$connId == null ? other$connId != null : !((Object)this$connId).equals(other$connId)) {
            return false;
        }
        Integer this$jobId = this.getJobId();
        Integer other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        Integer this$fileId = this.getFileId();
        Integer other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !((Object)this$fileId).equals(other$fileId)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        LoadOptions this$options = this.getOptions();
        LoadOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        Set<String> this$vertices = this.getVertices();
        Set<String> other$vertices = other.getVertices();
        if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
            return false;
        }
        Set<String> this$edges = this.getEdges();
        Set<String> other$edges = other.getEdges();
        if (this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges)) {
            return false;
        }
        Long this$fileTotalLines = this.getFileTotalLines();
        Long other$fileTotalLines = other.getFileTotalLines();
        if (this$fileTotalLines == null ? other$fileTotalLines != null : !((Object)this$fileTotalLines).equals(other$fileTotalLines)) {
            return false;
        }
        LoadStatus this$status = this.getStatus();
        LoadStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Long this$fileReadLines = this.getFileReadLines();
        Long other$fileReadLines = other.getFileReadLines();
        if (this$fileReadLines == null ? other$fileReadLines != null : !((Object)this$fileReadLines).equals(other$fileReadLines)) {
            return false;
        }
        Long this$lastDuration = this.getLastDuration();
        Long other$lastDuration = other.getLastDuration();
        if (this$lastDuration == null ? other$lastDuration != null : !((Object)this$lastDuration).equals(other$lastDuration)) {
            return false;
        }
        Long this$currDuration = this.getCurrDuration();
        Long other$currDuration = other.getCurrDuration();
        if (this$currDuration == null ? other$currDuration != null : !((Object)this$currDuration).equals(other$currDuration)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoadTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $connId = this.getConnId();
        result = result * 59 + ($connId == null ? 43 : ((Object)$connId).hashCode());
        Integer $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        Integer $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : ((Object)$fileId).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        LoadOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        Set<String> $vertices = this.getVertices();
        result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
        Set<String> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        Long $fileTotalLines = this.getFileTotalLines();
        result = result * 59 + ($fileTotalLines == null ? 43 : ((Object)$fileTotalLines).hashCode());
        LoadStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Long $fileReadLines = this.getFileReadLines();
        result = result * 59 + ($fileReadLines == null ? 43 : ((Object)$fileReadLines).hashCode());
        Long $lastDuration = this.getLastDuration();
        result = result * 59 + ($lastDuration == null ? 43 : ((Object)$lastDuration).hashCode());
        Long $currDuration = this.getCurrDuration();
        result = result * 59 + ($currDuration == null ? 43 : ((Object)$currDuration).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "LoadTask(lock=" + this.getLock() + ", loader=" + this.getLoader() + ", finished=" + this.isFinished() + ", id=" + this.getId() + ", connId=" + this.getConnId() + ", jobId=" + this.getJobId() + ", fileId=" + this.getFileId() + ", fileName=" + this.getFileName() + ", options=" + this.getOptions() + ", vertices=" + this.getVertices() + ", edges=" + this.getEdges() + ", fileTotalLines=" + this.getFileTotalLines() + ", status=" + (Object)((Object)this.getStatus()) + ", fileReadLines=" + this.getFileReadLines() + ", lastDuration=" + this.getLastDuration() + ", currDuration=" + this.getCurrDuration() + ", createTime=" + this.getCreateTime() + ")";
    }

    public LoadTask() {
    }

    public LoadTask(HugeGraphLoader loader, boolean finished, Integer id, Integer connId, Integer jobId, Integer fileId, String fileName, LoadOptions options, Set<String> vertices, Set<String> edges, Long fileTotalLines, LoadStatus status, Long fileReadLines, Long lastDuration, Long currDuration, Date createTime) {
        this.loader = loader;
        this.finished = finished;
        this.id = id;
        this.connId = connId;
        this.jobId = jobId;
        this.fileId = fileId;
        this.fileName = fileName;
        this.options = options;
        this.vertices = vertices;
        this.edges = edges;
        this.fileTotalLines = fileTotalLines;
        this.status = status;
        this.fileReadLines = fileReadLines;
        this.lastDuration = lastDuration;
        this.currDuration = currDuration;
        this.createTime = createTime;
    }

    public static class LoadTaskBuilder {
        private HugeGraphLoader loader;
        private boolean finished;
        private Integer id;
        private Integer connId;
        private Integer jobId;
        private Integer fileId;
        private String fileName;
        private LoadOptions options;
        private Set<String> vertices;
        private Set<String> edges;
        private Long fileTotalLines;
        private LoadStatus status;
        private Long fileReadLines;
        private Long lastDuration;
        private Long currDuration;
        private Date createTime;

        LoadTaskBuilder() {
        }

        public LoadTaskBuilder loader(HugeGraphLoader loader) {
            this.loader = loader;
            return this;
        }

        public LoadTaskBuilder finished(boolean finished) {
            this.finished = finished;
            return this;
        }

        @JsonProperty(value="id")
        public LoadTaskBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="conn_id")
        public LoadTaskBuilder connId(Integer connId) {
            this.connId = connId;
            return this;
        }

        @JsonProperty(value="job_id")
        public LoadTaskBuilder jobId(Integer jobId) {
            this.jobId = jobId;
            return this;
        }

        @JsonProperty(value="file_id")
        public LoadTaskBuilder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        @JsonProperty(value="file_name")
        public LoadTaskBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @JsonProperty(value="options", access=JsonProperty.Access.WRITE_ONLY)
        public LoadTaskBuilder options(LoadOptions options) {
            this.options = options;
            return this;
        }

        @JsonProperty(value="vertices")
        public LoadTaskBuilder vertices(Set<String> vertices) {
            this.vertices = vertices;
            return this;
        }

        @JsonProperty(value="edges")
        public LoadTaskBuilder edges(Set<String> edges) {
            this.edges = edges;
            return this;
        }

        @JsonProperty(value="file_total_lines")
        public LoadTaskBuilder fileTotalLines(Long fileTotalLines) {
            this.fileTotalLines = fileTotalLines;
            return this;
        }

        @JsonProperty(value="status")
        public LoadTaskBuilder status(LoadStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="file_read_lines")
        public LoadTaskBuilder fileReadLines(Long fileReadLines) {
            this.fileReadLines = fileReadLines;
            return this;
        }

        @JsonProperty(value="last_duration")
        public LoadTaskBuilder lastDuration(Long lastDuration) {
            this.lastDuration = lastDuration;
            return this;
        }

        @JsonProperty(value="curr_duration")
        public LoadTaskBuilder currDuration(Long currDuration) {
            this.currDuration = currDuration;
            return this;
        }

        @JsonProperty(value="create_time")
        public LoadTaskBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public LoadTask build() {
            return new LoadTask(this.loader, this.finished, this.id, this.connId, this.jobId, this.fileId, this.fileName, this.options, this.vertices, this.edges, this.fileTotalLines, this.status, this.fileReadLines, this.lastDuration, this.currDuration, this.createTime);
        }

        public String toString() {
            return "LoadTask.LoadTaskBuilder(loader=" + this.loader + ", finished=" + this.finished + ", id=" + this.id + ", connId=" + this.connId + ", jobId=" + this.jobId + ", fileId=" + this.fileId + ", fileName=" + this.fileName + ", options=" + this.options + ", vertices=" + this.vertices + ", edges=" + this.edges + ", fileTotalLines=" + this.fileTotalLines + ", status=" + (Object)((Object)this.status) + ", fileReadLines=" + this.fileReadLines + ", lastDuration=" + this.lastDuration + ", currDuration=" + this.currDuration + ", createTime=" + this.createTime + ")";
        }
    }
}

