/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class RebalanceListenerMetrics {
    private static final String TASKS_REVOKED = "tasks-revoked";
    private static final String TASKS_ASSIGNED = "tasks-assigned";
    private static final String TASKS_LOST = "tasks-lost";
    private static final String TASKS_REVOKED_AVG_LATENCY_DESCRIPTION = "The average time taken for tasks-revoked rebalance listener callback";
    private static final String TASKS_REVOKED_MAX_LATENCY_DESCRIPTION = "The max time taken for tasks-revoked rebalance listener callback";
    private static final String TASKS_ASSIGNED_AVG_LATENCY_DESCRIPTION = "The average time taken for tasks-assigned rebalance listener callback";
    private static final String TASKS_ASSIGNED_MAX_LATENCY_DESCRIPTION = "The max time taken for tasks-assigned rebalance listener callback";
    private static final String TASKS_LOST_AVG_LATENCY_DESCRIPTION = "The average time taken for tasks-lost rebalance listener callback";
    private static final String TASKS_LOST_MAX_LATENCY_DESCRIPTION = "The max time taken for tasks-lost rebalance listener callback";

    private RebalanceListenerMetrics() {
    }

    public static Sensor tasksRevokedSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return RebalanceListenerMetrics.rebalanceLatencySensor(threadId, TASKS_REVOKED, TASKS_REVOKED_AVG_LATENCY_DESCRIPTION, TASKS_REVOKED_MAX_LATENCY_DESCRIPTION, streamsMetrics);
    }

    public static Sensor tasksAssignedSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return RebalanceListenerMetrics.rebalanceLatencySensor(threadId, TASKS_ASSIGNED, TASKS_ASSIGNED_AVG_LATENCY_DESCRIPTION, TASKS_ASSIGNED_MAX_LATENCY_DESCRIPTION, streamsMetrics);
    }

    public static Sensor tasksLostSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return RebalanceListenerMetrics.rebalanceLatencySensor(threadId, TASKS_LOST, TASKS_LOST_AVG_LATENCY_DESCRIPTION, TASKS_LOST_MAX_LATENCY_DESCRIPTION, streamsMetrics);
    }

    private static Sensor rebalanceLatencySensor(String threadId, String operation, String avgDescription, String maxDescription, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, operation + "-latency", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-thread-metrics", tagMap, operation + "-latency", avgDescription, maxDescription);
        return sensor;
    }
}

