/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import kafka.server.ExpiringErrorCache$Entry$;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t]a!B\u0015+\u0001)r\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011i\u0002!\u0011!Q\u0001\nmBQ\u0001\u0013\u0001\u0005\u0002%3AA\u0014\u0001E\u001f\"Aq\f\u0002BK\u0002\u0013\u0005\u0001\r\u0003\u0005j\t\tE\t\u0015!\u0003b\u0011!QGA!f\u0001\n\u0003\u0001\u0007\u0002C6\u0005\u0005#\u0005\u000b\u0011B1\t\u00111$!Q3A\u0005\u00025D\u0001\"\u001d\u0003\u0003\u0012\u0003\u0006IA\u001c\u0005\u0006\u0011\u0012!\tA\u001d\u0005\bq\u0012\t\t\u0011\"\u0001z\u0011\u001diH!%A\u0005\u0002yD\u0001\"a\u0005\u0005#\u0003%\tA \u0005\n\u0003+!\u0011\u0013!C\u0001\u0003/A\u0011\"a\u0007\u0005\u0003\u0003%\t%!\b\t\u0013\u00055B!!A\u0005\u0002\u0005=\u0002\"CA\u0019\t\u0005\u0005I\u0011AA\u001a\u0011%\ty\u0004BA\u0001\n\u0003\n\t\u0005C\u0005\u0002P\u0011\t\t\u0011\"\u0001\u0002R!I\u00111\f\u0003\u0002\u0002\u0013\u0005\u0013Q\f\u0005\n\u0003C\"\u0011\u0011!C!\u0003GB\u0011\"!\u001a\u0005\u0003\u0003%\t%a\u001a\t\u0013\u0005%D!!A\u0005B\u0005-t!CA8\u0001\u0005\u0005\t\u0012BA9\r!q\u0005!!A\t\n\u0005M\u0004B\u0002%\u001b\t\u0003\tY\tC\u0005\u0002fi\t\t\u0011\"\u0012\u0002h!I\u0011Q\u0012\u000e\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003/S\u0012\u0011!CA\u00033C\u0011\"a+\u0001\u0005\u0004%I!!,\t\u0011\u0005}\u0006\u0001)A\u0005\u0003_C\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000bD\u0011\"a4\u0001\u0005\u0004%I!!5\t\u0011\u0005}\u0007\u0001)A\u0005\u0003'Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"A!1\u0003\u0001\u0005\u0002)\u0012)B\u0001\nFqBL'/\u001b8h\u000bJ\u0014xN]\"bG\",'BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fq!\\1y'&TXm\u0001\u0001\u0011\u0005AB\u0014BA\u001d2\u0005\rIe\u000e^\u0001\u0005i&lW\r\u0005\u0002=\r6\tQH\u0003\u0002?\u007f\u0005)Q\u000f^5mg*\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u00055\u0012%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!aR\u001f\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)cU\n\u0005\u0002L\u00015\t!\u0006C\u00036\u0007\u0001\u0007q\u0007C\u0003;\u0007\u0001\u00071HA\u0003F]R\u0014\u0018p\u0005\u0003\u0005_A\u001b\u0006C\u0001\u0019R\u0013\t\u0011\u0016GA\u0004Qe>$Wo\u0019;\u0011\u0005QcfBA+[\u001d\t1\u0016,D\u0001X\u0015\tAf'\u0001\u0004=e>|GOP\u0005\u0002e%\u00111,M\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002\\c\u0005IAo\u001c9jG:\u000bW.Z\u000b\u0002CB\u0011!M\u001a\b\u0003G\u0012\u0004\"AV\u0019\n\u0005\u0015\f\u0014A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z\u0019\u0002\u0015Q|\u0007/[2OC6,\u0007%\u0001\u0007feJ|'/T3tg\u0006<W-A\u0007feJ|'/T3tg\u0006<W\rI\u0001\u0011Kb\u0004\u0018N]1uS>tG+[7f\u001bN,\u0012A\u001c\t\u0003a=L!\u0001]\u0019\u0003\t1{gnZ\u0001\u0012Kb\u0004\u0018N]1uS>tG+[7f\u001bN\u0004C\u0003B:vm^\u0004\"\u0001\u001e\u0003\u000e\u0003\u0001AQaX\u0006A\u0002\u0005DQA[\u0006A\u0002\u0005DQ\u0001\\\u0006A\u00029\fAaY8qsR!1O_>}\u0011\u001dyF\u0002%AA\u0002\u0005DqA\u001b\u0007\u0011\u0002\u0003\u0007\u0011\rC\u0004m\u0019A\u0005\t\u0019\u00018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqPK\u0002b\u0003\u0003Y#!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\t\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011CA\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0007+\u00079\f\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003mC:<'BAA\u0015\u0003\u0011Q\u0017M^1\n\u0007\u001d\f\u0019#\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u00018\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u0019\u0001'a\u000e\n\u0007\u0005e\u0012GA\u0002B]fD\u0001\"!\u0010\u0013\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0003CBA#\u0003\u0017\n)$\u0004\u0002\u0002H)\u0019\u0011\u0011J\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0005\u001d#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0015\u0002ZA\u0019\u0001'!\u0016\n\u0007\u0005]\u0013GA\u0004C_>dW-\u00198\t\u0013\u0005uB#!AA\u0002\u0005U\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\b\u0002`!A\u0011QH\u000b\u0002\u0002\u0003\u0007q'\u0001\u0005iCND7i\u001c3f)\u00059\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002T\u00055\u0004\"CA\u001f1\u0005\u0005\t\u0019AA\u001b\u0003\u0015)e\u000e\u001e:z!\t!(dE\u0003\u001b\u0003k\n\t\t\u0005\u0005\u0002x\u0005u\u0014-\u00198t\u001b\t\tIHC\u0002\u0002|E\nqA];oi&lW-\u0003\u0003\u0002\u0000\u0005e$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u00111QAE\u001b\t\t)I\u0003\u0003\u0002\b\u0006\u001d\u0012AA5p\u0013\ri\u0016Q\u0011\u000b\u0003\u0003c\nQ!\u00199qYf$ra]AI\u0003'\u000b)\nC\u0003`;\u0001\u0007\u0011\rC\u0003k;\u0001\u0007\u0011\rC\u0003m;\u0001\u0007a.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u0015q\u0015\t\u0006a\u0005u\u0015\u0011U\u0005\u0004\u0003?\u000b$AB(qi&|g\u000e\u0005\u00041\u0003G\u000b\u0017M\\\u0005\u0004\u0003K\u000b$A\u0002+va2,7\u0007\u0003\u0005\u0002*z\t\t\u00111\u0001t\u0003\rAH\u0005M\u0001\bEf$v\u000e]5d+\t\ty\u000b\u0005\u0004\u00022\u0006m\u0016m]\u0007\u0003\u0003gSA!!.\u00028\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005e\u0016qE\u0001\u0005kRLG.\u0003\u0003\u0002>\u0006M&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['ba\u0006A!-\u001f+pa&\u001c\u0007%A\u0006fqBL'/_)vKV,WCAAc!\u0015\t9-!3t\u001b\t\t9,\u0003\u0003\u0002L\u0006]&!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X-\u0001\u0007fqBL'/_)vKV,\u0007%\u0001\u0003m_\u000e\\WCAAj!\u0011\t).a7\u000e\u0005\u0005]'\u0002BAm\u0003g\u000bQ\u0001\\8dWNLA!!8\u0002X\ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\n1\u0001];u)!\t)/a;\u0002n\u0006=\bc\u0001\u0019\u0002h&\u0019\u0011\u0011^\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006?\u0016\u0002\r!\u0019\u0005\u0006U\u0016\u0002\r!\u0019\u0005\u0007\u0003c,\u0003\u0019\u00018\u0002\u000bQ$H.T:\u0002\u0011!\f7/\u0012:s_J$b!a\u0015\u0002x\u0006e\b\"B0'\u0001\u0004\t\u0007BBA~M\u0001\u0007a.A\u0007dkJ\u0014XM\u001c;US6,Wj]\u0001\u0013O\u0016$XI\u001d:peN4uN\u001d+pa&\u001c7\u000f\u0006\u0004\u0003\u0002\t\u001d!\u0011\u0003\t\u0007\u0003\u000b\u0012\u0019!Y1\n\t\t\u0015\u0011q\t\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u0005O\u0001\u0007!1B\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u001c\b#BA#\u0005\u001b\t\u0017\u0002\u0002B\b\u0003\u000f\u00121aU3u\u0011\u0019\tYp\na\u0001]\u0006)1\r\\3beR\u0011\u0011Q\u001d")
public class ExpiringErrorCache {
    private volatile ExpiringErrorCache$Entry$ Entry$module;
    private final int maxSize;
    private final Time time;
    private final ConcurrentHashMap<String, Entry> byTopic;
    private final PriorityQueue<Entry> expiryQueue;
    private final ReentrantLock lock;

    private ExpiringErrorCache$Entry$ Entry() {
        if (this.Entry$module == null) {
            this.Entry$lzycompute$1();
        }
        return this.Entry$module;
    }

    private ConcurrentHashMap<String, Entry> byTopic() {
        return this.byTopic;
    }

    private PriorityQueue<Entry> expiryQueue() {
        return this.expiryQueue;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public void put(String topicName, String errorMessage, long ttlMs) {
        this.lock().lock();
        try {
            long currentTimeMs = this.time.milliseconds();
            long expirationTimeMs = currentTimeMs + ttlMs;
            Entry entry = new Entry(this, topicName, errorMessage, expirationTimeMs);
            this.byTopic().put(topicName, entry);
            this.expiryQueue().add(entry);
            while (!(this.expiryQueue().isEmpty() || this.expiryQueue().peek().expirationTimeMs() > currentTimeMs && this.byTopic().size() <= this.maxSize)) {
                Entry evicted = this.expiryQueue().poll();
                Entry current = this.byTopic().get(evicted.topicName());
                if (current == null || current != evicted) continue;
                this.byTopic().remove(evicted.topicName());
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public boolean hasError(String topicName, long currentTimeMs) {
        Entry entry = this.byTopic().get(topicName);
        return entry != null && entry.expirationTimeMs() > currentTimeMs;
    }

    public Map<String, String> getErrorsForTopics(Set<String> topicNames, long currentTimeMs) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicNames.foreach((Function1 & Serializable)topicName -> {
            Entry entry = this.byTopic().get(topicName);
            if (entry != null && entry.expirationTimeMs() > currentTimeMs) {
                return result.put(topicName, (Object)entry.errorMessage());
            }
            return BoxedUnit.UNIT;
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void clear() {
        this.lock().lock();
        try {
            this.byTopic().clear();
            this.expiryQueue().clear();
        }
        finally {
            this.lock().unlock();
        }
    }

    private final void Entry$lzycompute$1() {
        synchronized (this) {
            if (this.Entry$module == null) {
                this.Entry$module = new ExpiringErrorCache$Entry$(this);
            }
            return;
        }
    }

    public ExpiringErrorCache(int maxSize, Time time) {
        this.maxSize = maxSize;
        this.time = time;
        this.byTopic = new ConcurrentHashMap();
        this.expiryQueue = new PriorityQueue<Entry>(11, new Comparator<Entry>(null){

            public Comparator<Entry> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Entry> thenComparing(Comparator<? super Entry> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Entry> thenComparing(Function<? super Entry, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Entry> thenComparing(Function<? super Entry, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Entry> thenComparingInt(ToIntFunction<? super Entry> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Entry> thenComparingLong(ToLongFunction<? super Entry> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Entry> thenComparingDouble(ToDoubleFunction<? super Entry> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Entry a, Entry b) {
                return Long.compare(a.expirationTimeMs(), b.expirationTimeMs());
            }
        });
        this.lock = new ReentrantLock();
    }

    private class Entry
    implements Product,
    Serializable {
        private final String topicName;
        private final String errorMessage;
        private final long expirationTimeMs;
        public final /* synthetic */ ExpiringErrorCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String topicName() {
            return this.topicName;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public long expirationTimeMs() {
            return this.expirationTimeMs;
        }

        public Entry copy(String topicName, String errorMessage, long expirationTimeMs) {
            return new Entry(this.kafka$server$ExpiringErrorCache$Entry$$$outer(), topicName, errorMessage, expirationTimeMs);
        }

        public String copy$default$1() {
            return this.topicName();
        }

        public String copy$default$2() {
            return this.errorMessage();
        }

        public long copy$default$3() {
            return this.expirationTimeMs();
        }

        public String productPrefix() {
            return "Entry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.topicName();
                }
                case 1: {
                    return this.errorMessage();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.expirationTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Entry;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "topicName";
                }
                case 1: {
                    return "errorMessage";
                }
                case 2: {
                    return "expirationTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)67115090), (int)Statics.anyHash((Object)this.topicName())), (int)Statics.anyHash((Object)this.errorMessage())), (int)Statics.longHash((long)this.expirationTimeMs())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Entry && ((Entry)x$1).kafka$server$ExpiringErrorCache$Entry$$$outer() == this.kafka$server$ExpiringErrorCache$Entry$$$outer())) break block3;
                    Entry entry = (Entry)x$1;
                    if (this.expirationTimeMs() != entry.expirationTimeMs()) break block3;
                    String string = this.topicName();
                    String string2 = entry.topicName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.errorMessage();
                    String string4 = entry.errorMessage();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !entry.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ExpiringErrorCache kafka$server$ExpiringErrorCache$Entry$$$outer() {
            return this.$outer;
        }

        public Entry(ExpiringErrorCache $outer, String topicName, String errorMessage, long expirationTimeMs) {
            this.topicName = topicName;
            this.errorMessage = errorMessage;
            this.expirationTimeMs = expirationTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

