/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import java.util.Base64;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonArray;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.json.impl.JsonUtil;
import org.apache.kyuubi.shade.io.vertx.core.net.PemTrustOptions;

public class PemTrustOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemTrustOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCertPath((String)item);
                        }
                    });
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCertValue(Buffer.buffer(BASE64_DECODER.decode((String)item)));
                        }
                    });
                }
            }
        }
    }

    static void toJson(PemTrustOptions obj, JsonObject json) {
        PemTrustOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PemTrustOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add(item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("certValues", array);
        }
    }
}

