/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageEventCallbacks;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.TaskPool;

public class StageConfig {
    private boolean frozen;
    private IOStatisticsStore iostatistics;
    private String jobId;
    private String jobIdSource = "";
    private int jobAttemptNumber;
    private String taskId;
    private String taskAttemptId;
    private Path destinationDir;
    private Path jobAttemptDir;
    private Path outputTempSubDir;
    private Path taskAttemptDir;
    private Path taskManifestDir;
    private Path jobAttemptTaskSubDir;
    private ManifestStoreOperations operations;
    private TaskPool.Submitter ioProcessors;
    private Progressable progressable;
    private StageEventCallbacks enterStageEventHandler;
    private final ThreadLocal<JsonSerialization<TaskManifest>> threadLocalSerializer = ThreadLocal.withInitial(TaskManifest::serializer);
    private boolean deleteTargetPaths;
    private String name = "";
    private Configuration conf = new Configuration();
    private int writerQueueCapacity = 32;
    private int successMarkerFileLimit = 100;

    private void checkOpen() {
        Preconditions.checkState(!this.frozen, "StageConfig is now read-only");
    }

    public StageConfig build() {
        this.frozen = true;
        return this;
    }

    public StageConfig withDestinationDir(Path dir) {
        this.destinationDir = dir;
        return this;
    }

    public StageConfig withIOStatistics(IOStatisticsStore store) {
        this.checkOpen();
        this.iostatistics = store;
        return this;
    }

    public StageConfig withIOProcessors(TaskPool.Submitter value) {
        this.checkOpen();
        this.ioProcessors = value;
        return this;
    }

    public StageConfig withJobAttemptDir(Path dir) {
        this.checkOpen();
        this.jobAttemptDir = dir;
        return this;
    }

    public Path getTaskManifestDir() {
        return this.taskManifestDir;
    }

    public StageConfig withTaskManifestDir(Path value) {
        this.checkOpen();
        this.taskManifestDir = value;
        return this;
    }

    public StageConfig withJobAttemptTaskSubDir(Path value) {
        this.jobAttemptTaskSubDir = value;
        return this;
    }

    public Path getJobAttemptTaskSubDir() {
        return this.jobAttemptTaskSubDir;
    }

    public StageConfig withJobDirectories(ManifestCommitterSupport.AttemptDirectories dirs) {
        this.checkOpen();
        this.withJobAttemptDir(dirs.getJobAttemptDir()).withJobAttemptTaskSubDir(dirs.getJobAttemptTaskSubDir()).withDestinationDir(dirs.getOutputPath()).withOutputTempSubDir(dirs.getOutputTempSubDir()).withTaskManifestDir(dirs.getTaskManifestDir());
        return this;
    }

    public StageConfig withJobId(String value) {
        this.checkOpen();
        this.jobId = value;
        return this;
    }

    public Path getOutputTempSubDir() {
        return this.outputTempSubDir;
    }

    public StageConfig withOutputTempSubDir(Path value) {
        this.checkOpen();
        this.outputTempSubDir = value;
        return this;
    }

    public StageConfig withOperations(ManifestStoreOperations value) {
        this.checkOpen();
        this.operations = value;
        return this;
    }

    public StageConfig withTaskAttemptId(String value) {
        this.checkOpen();
        this.taskAttemptId = value;
        return this;
    }

    public StageConfig withTaskId(String value) {
        this.checkOpen();
        this.taskId = value;
        return this;
    }

    public StageConfig withStageEventCallbacks(StageEventCallbacks value) {
        this.checkOpen();
        this.enterStageEventHandler = value;
        return this;
    }

    public StageConfig withProgressable(Progressable value) {
        this.checkOpen();
        this.progressable = value;
        return this;
    }

    public StageConfig withTaskAttemptDir(Path value) {
        this.checkOpen();
        this.taskAttemptDir = value;
        return this;
    }

    public StageConfig withJobAttemptNumber(int value) {
        this.checkOpen();
        this.jobAttemptNumber = value;
        return this;
    }

    public StageConfig withJobIdSource(String value) {
        this.checkOpen();
        this.jobIdSource = value;
        return this;
    }

    public StageConfig withName(String value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public StageConfig withConfiguration(Configuration value) {
        this.conf = value;
        return this;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getWriterQueueCapacity() {
        return this.writerQueueCapacity;
    }

    public StageConfig withWriterQueueCapacity(int value) {
        this.writerQueueCapacity = value;
        return this;
    }

    public StageEventCallbacks getEnterStageEventHandler() {
        return this.enterStageEventHandler;
    }

    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public Path getJobAttemptDir() {
        return this.jobAttemptDir;
    }

    public Path getDestinationDir() {
        return this.destinationDir;
    }

    public Path getJobSuccessMarkerPath() {
        return new Path(this.destinationDir, "_SUCCESS");
    }

    public ManifestStoreOperations getOperations() {
        return this.operations;
    }

    public TaskPool.Submitter getIoProcessors() {
        return this.ioProcessors;
    }

    public Progressable getProgressable() {
        return this.progressable;
    }

    public Path getTaskAttemptDir() {
        return this.taskAttemptDir;
    }

    public int getJobAttemptNumber() {
        return this.jobAttemptNumber;
    }

    public String getJobIdSource() {
        return this.jobIdSource;
    }

    public JsonSerialization<TaskManifest> currentManifestSerializer() {
        return this.threadLocalSerializer.get();
    }

    public StageConfig withDeleteTargetPaths(boolean value) {
        this.checkOpen();
        this.deleteTargetPaths = value;
        return this;
    }

    public boolean getDeleteTargetPaths() {
        return this.deleteTargetPaths;
    }

    public StageConfig withSuccessMarkerFileLimit(int value) {
        this.checkOpen();
        this.successMarkerFileLimit = value;
        return this;
    }

    public int getSuccessMarkerFileLimit() {
        return this.successMarkerFileLimit;
    }

    public void enterStage(String stage) {
        if (this.enterStageEventHandler != null) {
            this.enterStageEventHandler.enterStage(stage);
        }
    }

    public void exitStage(String stage) {
        if (this.enterStageEventHandler != null) {
            this.enterStageEventHandler.exitStage(stage);
        }
    }
}

