/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.extension.auth.opa.model.ResourceEntity;
import org.immutables.value.Generated;

@Generated(from="ResourceEntity", generator="Immutables")
public final class ImmutableResourceEntity
implements ResourceEntity {
    private final String type;
    private final String name;
    private final ImmutableList<ResourceEntity> parents;
    private transient int hashCode;

    private ImmutableResourceEntity(String type, String name, ImmutableList<ResourceEntity> parents) {
        this.type = type;
        this.name = name;
        this.parents = parents;
    }

    @Override
    @JsonProperty(required=true)
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(required=true)
    public String name() {
        return this.name;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ImmutableList<ResourceEntity> parents() {
        return this.parents;
    }

    public final ImmutableResourceEntity withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableResourceEntity(newValue, this.name, this.parents);
    }

    public final ImmutableResourceEntity withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableResourceEntity(this.type, newValue, this.parents);
    }

    public final ImmutableResourceEntity withParents(ResourceEntity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableResourceEntity(this.type, this.name, (ImmutableList<ResourceEntity>)newValue);
    }

    public final ImmutableResourceEntity withParents(Iterable<? extends ResourceEntity> elements) {
        if (this.parents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableResourceEntity(this.type, this.name, (ImmutableList<ResourceEntity>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourceEntity && this.equalsByValue((ImmutableResourceEntity)another);
    }

    private boolean equalsByValue(ImmutableResourceEntity another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.type.equals(another.type) && this.name.equals(another.name) && this.parents.equals(another.parents);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.parents.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResourceEntity").omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).add("parents", this.parents).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResourceEntity fromJson(Json json) {
        Builder builder = ImmutableResourceEntity.builder();
        if (json._type != null) {
            builder.type(json._type);
        }
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._parents != null) {
            builder.addAllParents(json._parents);
        }
        return builder.build();
    }

    public static ImmutableResourceEntity copyOf(ResourceEntity instance) {
        if (instance instanceof ImmutableResourceEntity) {
            return (ImmutableResourceEntity)instance;
        }
        return ImmutableResourceEntity.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableResourceEntity.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ResourceEntity", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private String type;
        private String name;
        private ImmutableList.Builder<ResourceEntity> parents = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ResourceEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.name(instance.name());
            this.addAllParents(instance.parents());
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParent(ResourceEntity element) {
            this.parents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(ResourceEntity ... elements) {
            this.parents.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder parents(Iterable<? extends ResourceEntity> elements) {
            this.parents = ImmutableList.builder();
            return this.addAllParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParents(Iterable<? extends ResourceEntity> elements) {
            this.parents.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.type = null;
            this.name = null;
            this.parents = ImmutableList.builder();
            return this;
        }

        public ImmutableResourceEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResourceEntity(this.type, this.name, (ImmutableList<ResourceEntity>)this.parents.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ResourceEntity, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ResourceEntity", generator="Immutables")
    static final class Json
    implements ResourceEntity {
        @JsonIgnore
        String _type;
        @JsonIgnore
        String _name;
        @JsonIgnore
        List<ResourceEntity> _parents = ImmutableList.of();

        Json() {
        }

        @JsonProperty(required=true)
        public void setType(String type) {
            this._type = type;
        }

        @JsonProperty(required=true)
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setParents(List<ResourceEntity> parents) {
            this._parents = parents;
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ResourceEntity> parents() {
            throw new UnsupportedOperationException();
        }
    }
}

