﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-thin-client/WorkSpacesThinClient_EXPORTS.h>
#include <aws/workspaces-thin-client/model/Device.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesThinClient {
namespace Model {
class GetDeviceResult {
 public:
  AWS_WORKSPACESTHINCLIENT_API GetDeviceResult() = default;
  AWS_WORKSPACESTHINCLIENT_API GetDeviceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESTHINCLIENT_API GetDeviceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Describes an device.</p>
   */
  inline const Device& GetDevice() const { return m_device; }
  template <typename DeviceT = Device>
  void SetDevice(DeviceT&& value) {
    m_deviceHasBeenSet = true;
    m_device = std::forward<DeviceT>(value);
  }
  template <typename DeviceT = Device>
  GetDeviceResult& WithDevice(DeviceT&& value) {
    SetDevice(std::forward<DeviceT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetDeviceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Device m_device;

  Aws::String m_requestId;
  bool m_deviceHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesThinClient
}  // namespace Aws
