/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class PrefUtils {
    private static final Log log = Log.getLog(PrefUtils.class);

    public static void savePreferenceStore(@NotNull DBPPreferenceStore store) {
        try {
            store.save();
        }
        catch (IOException e) {
            log.warn(e);
        }
    }

    public static void setDefaultPreferenceValue(@NotNull DBPPreferenceStore store, @NotNull String name, @NotNull Object value) {
        if (CommonUtils.isEmpty((String)store.getDefaultString(name))) {
            store.setDefault(name, value.toString());
        }
    }

    @Nullable
    public static Object getPreferenceValue(@NotNull DBPPreferenceStore store, @NotNull String propName, @Nullable Class<?> valueType) {
        try {
            String str = store.getString(propName);
            if (str == null) {
                return null;
            }
            if (valueType == null || CharSequence.class.isAssignableFrom(valueType)) {
                return CommonUtils.isEmpty((String)str) ? null : str;
            }
            if (valueType == Boolean.class || valueType == Boolean.TYPE) {
                return CommonUtils.toBoolean((Object)str);
            }
            if (valueType == Long.class || valueType == Long.TYPE) {
                return CommonUtils.toLong((Object)str);
            }
            if (valueType == Integer.class || valueType == Integer.TYPE || valueType == Short.class || valueType == Short.TYPE || valueType == Byte.class || valueType == Byte.TYPE) {
                return CommonUtils.toInt((Object)str);
            }
            if (valueType == Double.class || valueType == Double.TYPE) {
                return CommonUtils.toDouble((Object)str);
            }
            if (valueType == Float.class || valueType == Float.TYPE) {
                return Float.valueOf(CommonUtils.toFloat((Object)store));
            }
            if (valueType == BigInteger.class) {
                return new BigInteger(str);
            }
            if (valueType == BigDecimal.class) {
                return new BigDecimal(str);
            }
        }
        catch (RuntimeException e) {
            log.error(e);
        }
        String string = store.getString(propName);
        return CommonUtils.isEmpty((String)string) ? null : string;
    }

    public static void setPreferenceValue(@NotNull DBPPreferenceStore store, @NotNull String propName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setValue(propName, value.toString());
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            store.setValue(propName, b);
        } else if (value instanceof Long) {
            Long l = (Long)value;
            store.setValue(propName, l);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setValue(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            Double d = (Double)value;
            store.setValue(propName, d);
        } else if (value instanceof Float) {
            Float f = (Float)value;
            store.setValue(propName, f.floatValue());
        } else {
            store.setValue(propName, value.toString());
        }
    }

    public static void setPreferenceDefaultValue(@NotNull DBPPreferenceStore store, @NotNull String propName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setDefault(propName, value.toString());
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            store.setDefault(propName, b);
        } else if (value instanceof Long) {
            Long l = (Long)value;
            store.setDefault(propName, l);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setDefault(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            Double d = (Double)value;
            store.setDefault(propName, d);
        } else if (value instanceof Float) {
            Float f = (Float)value;
            store.setDefault(propName, f.floatValue());
        } else {
            store.setDefault(propName, value.toString());
        }
    }
}

