/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.common;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarksHandlerImpl;

public class AddBookmarkHandler
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            DBNNode node = NavigatorUtils.getSelectedNode((ISelection)selection);
            DBPProject project = node.getOwnerProject();
            if (project == null || !project.hasRealmPermission("project-resource-edit")) {
                return null;
            }
            if (node instanceof DBNDataSource) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.actions_navigator_bookmark_error_title, "Connection itself cannot be bookmarked. Choose some element under a connection element.");
                return null;
            }
            if (node instanceof DBNDatabaseNode) {
                DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                try {
                    AddBookmarkHandler.createBookmarkDialog(dbNode, activeShell);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(CoreMessages.actions_navigator_bookmark_error_title, CoreMessages.actions_navigator_bookmark_error_message, (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void createBookmarkDialog(DBNDatabaseNode node, Shell activeShell) throws DBException {
        AddBookmarkDialog dialog = new AddBookmarkDialog(activeShell, node);
        String title = dialog.chooseName();
        if (title != null) {
            BookmarksHandlerImpl.createBookmark(node, title, dialog.getTargetFolder());
        }
    }

    private static class AddBookmarkDialog
    extends EnterNameDialog {
        private IFolder targetFolder;
        private DBNDatabaseNode node;

        public AddBookmarkDialog(Shell parentShell, DBNDatabaseNode node) {
            super(parentShell, CoreMessages.actions_navigator_bookmark_title, node.getNodeDisplayName());
            this.node = node;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings((String)"DBeaver.AddBookmarkDialog");
        }

        protected Composite createDialogArea(Composite parent) {
            DBNResource bookmarksFolderNode;
            IFolder bookmarksFolder;
            Composite area = super.createDialogArea(parent);
            DBPProject project = this.node.getOwnerProject();
            if (project != null && (bookmarksFolder = BookmarksHandlerImpl.getBookmarksFolder(project, false)) != null && (bookmarksFolderNode = NavigatorResources.getNodeByResource((DBNModel)this.node.getModel(), (IResource)bookmarksFolder)) != null) {
                DBNResource targetNode;
                UIUtils.createControlLabel((Composite)area, (String)"Bookmark folder");
                DatabaseNavigatorTree foldersNavigator = new DatabaseNavigatorTree(area, (DBNNode)bookmarksFolderNode, 2052, true);
                GridData gd = new GridData(1808);
                gd.widthHint = 200;
                gd.heightHint = 200;
                foldersNavigator.setLayoutData((Object)gd);
                TreeViewer treeViewer = foldersNavigator.getViewer();
                if (this.targetFolder != null && this.targetFolder.exists() && (targetNode = NavigatorResources.getNodeByResource((DBNModel)this.node.getModel(), (IResource)this.targetFolder)) != null) {
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)targetNode));
                }
                treeViewer.addFilter(new ViewerFilter(this){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFolder;
                    }
                });
                treeViewer.addSelectionChangedListener(event -> {
                    Object object;
                    IStructuredSelection structSel = (IStructuredSelection)event.getSelection();
                    Object object2 = object = structSel.isEmpty() ? null : structSel.getFirstElement();
                    if (object instanceof DBNResource && ((DBNResource)object).getResource() instanceof IFolder) {
                        this.targetFolder = (IFolder)((DBNResource)object).getResource();
                    }
                });
                treeViewer.expandAll();
            }
            return area;
        }

        public IFolder getTargetFolder() {
            return this.targetFolder;
        }
    }
}

