/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator.resultset;

import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetDataProvider;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.resultset.SQLGeneratorResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class SQLGeneratorInsertFromData
extends SQLGeneratorResultSet {
    @Override
    public boolean isInsertOption() {
        return true;
    }

    @Override
    public boolean isDMLOption() {
        return true;
    }

    @Override
    protected void generateSQL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        for (DBDValueRow firstRow : dataProvider.getSelectedRows()) {
            Collection<? extends DBSAttributeBase> allAttributes = this.getAllAttributes(monitor, dataProvider);
            sql.append("INSERT INTO ").append(this.getEntityName(dataProvider.getSingleSource()));
            sql.append(this.getLineSeparator()).append("(");
            boolean hasAttr = false;
            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase) || this.isExcludeAutoGeneratedColumn() && dBSAttributeBase.isAutoGenerated()) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML));
                hasAttr = true;
            }
            sql.append(")").append(this.getLineSeparator()).append("VALUES(");
            hasAttr = false;
            for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                DBDAttributeBinding binding;
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase) || this.isExcludeAutoGeneratedColumn() && dBSAttributeBase.isAutoGenerated()) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                if ((binding = DBUtils.findBinding((DBDAttributeBinding[])dataProvider.getAttributes(), (DBSAttributeBase)dBSAttributeBase)) == null) {
                    this.appendDefaultValue(sql, dBSAttributeBase);
                } else {
                    this.appendAttributeValue(dataProvider, sql, binding, firstRow, false);
                }
                hasAttr = true;
            }
            sql.append(");\n");
        }
    }
}

