/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.dashboard.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.dashboard.DBDashboardContext;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.DBDashboardProvider;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardMapQueryDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DatabaseDashboardProvider
implements DBDashboardProvider {
    @Override
    @NotNull
    public String getId() {
        return "database";
    }

    @Override
    public List<DashboardItemConfiguration> loadStaticDashboards(@NotNull DashboardProviderDescriptor dp) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dashboard");
        ArrayList<DashboardItemConfiguration> dashboards = new ArrayList<DashboardItemConfiguration>();
        LinkedHashMap<String, DashboardMapQueryDescriptor> mapQueries = new LinkedHashMap<String, DashboardMapQueryDescriptor>();
        for (IConfigurationElement ext : extElements) {
            DashboardMapQueryDescriptor query;
            if (!"mapQuery".equals(ext.getName()) || CommonUtils.isEmpty((String)(query = new DashboardMapQueryDescriptor(ext)).getId()) || CommonUtils.isEmpty((String)query.getQueryText())) continue;
            mapQueries.put(query.getId(), query);
        }
        for (IConfigurationElement ext : extElements) {
            if (!"dashboard".equals(ext.getName())) continue;
            DashboardItemConfiguration dashboard = new DashboardItemConfiguration(dp, mapQueries::get, ext);
            if (!dashboard.isSupportedByLocalSystem()) continue;
            dashboards.add(dashboard);
        }
        return dashboards;
    }

    @Override
    @NotNull
    public List<DBDashboardFolder> loadRootFolders(@NotNull DBRProgressMonitor monitor, @NotNull DashboardProviderDescriptor provider, @NotNull DBDashboardContext context) {
        return List.of();
    }

    @Override
    public boolean appliesTo(@NotNull DBPDataSourceContainer dataSource) {
        return true;
    }
}

