/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.sql.JDBCType;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class CustomLocalDateTimeCellEditor
extends DialogCellEditor {
    private Text textEditor;
    private FocusListener textFocusListener;

    public CustomLocalDateTimeCellEditor(@NotNull Composite parent) {
        super(parent);
    }

    @Nullable
    protected Button createButton(@NotNull Composite parent) {
        Button result = new Button(parent, 525312);
        result.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.DOTS_BUTTON));
        return result;
    }

    @Nullable
    protected Control createContents(@NotNull Composite cell) {
        this.textEditor = new Text(cell, 16384);
        this.textEditor.setFont(cell.getFont());
        this.textEditor.setBackground(cell.getBackground());
        this.textEditor.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                e.detail = 0;
                this.focusLost();
            }
        });
        this.textFocusListener = FocusListener.focusLostAdapter(e -> {
            this.applyEditorValueFromText(this.textEditor.getText(), new Shell(cell.getShell()));
            UIUtils.asyncExec(() -> {
                if (!UIUtils.hasFocus((Control)cell)) {
                    this.fireApplyEditorValue();
                }
            });
        });
        this.textEditor.addFocusListener(this.textFocusListener);
        this.textEditor.addMouseListener(MouseListener.mouseDoubleClickAdapter(e -> {
            Object newValue = this.openDialogBox((Control)cell);
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
            }
        }));
        return this.textEditor;
    }

    @Nullable
    protected Object doGetValue() {
        return this.truncateToSeconds((LocalDateTime)super.doGetValue());
    }

    private void applyEditorValueFromText(@Nullable String text, @NotNull Shell shell) {
        if (CommonUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            LocalDateTime timestamp = LocalDateTime.parse(text);
            this.setValue(timestamp);
        }
        catch (Exception ex) {
            ErrorDialog.openError((Shell)shell, (String)"Failed to parse timestamp", null, (IStatus)Status.warning((String)"Invalid timestamp format", (Throwable)ex));
        }
    }

    @Nullable
    protected Object openDialogBox(Control cellEditorWindow) {
        this.textEditor.removeFocusListener(this.textFocusListener);
        Object currentValue = this.doGetValue();
        LocalDateTime initialValue = currentValue != null ? (LocalDateTime)currentValue : LocalDateTime.now().plusDays(30L);
        CustomTimeEditorDialog customTimeEditorDialog = new CustomTimeEditorDialog(cellEditorWindow.getShell(), initialValue);
        int returnCode = customTimeEditorDialog.open();
        Object result = switch (returnCode) {
            case 0 -> customTimeEditorDialog.result();
            case 1 -> currentValue;
            default -> null;
        };
        this.textEditor.clearSelection();
        this.textEditor.addFocusListener(this.textFocusListener);
        return result;
    }

    protected void updateContents(@Nullable Object value) {
        if (value == null) {
            this.textEditor.setText("");
            return;
        }
        this.textEditor.setText(value.toString());
        this.textEditor.selectAll();
    }

    protected void doSetFocus() {
        this.textEditor.setFocus();
    }

    protected void doSetValue(@Nullable Object value) {
        super.doSetValue((Object)this.truncateToSeconds((LocalDateTime)value));
    }

    private LocalDateTime truncateToSeconds(@Nullable LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.truncatedTo(ChronoUnit.SECONDS);
    }

    private static class CustomTimeEditorDialog
    extends BaseDialog {
        private static final Log log = Log.getLog(CustomTimeEditorDialog.class);
        @Nullable
        private LocalDateTime value;

        public CustomTimeEditorDialog(@NotNull Shell parent, @Nullable LocalDateTime value) {
            super(parent, "Select Date and Time", null);
            this.value = value;
        }

        @Override
        protected Composite createDialogArea(@NotNull Composite parent) {
            final CustomTimeEditor customTimeEditor = new CustomTimeEditor(parent, 0, false, false);
            customTimeEditor.createDateFormat(JDBCType.TIMESTAMP);
            GridData layoutData = new GridData(4, 0x1000000, true, false);
            customTimeEditor.getControl().setLayoutData((Object)layoutData);
            customTimeEditor.setEditable(true);
            try {
                customTimeEditor.setValue(this.value);
            }
            catch (DBCException e) {
                log.error((Object)"Error setting initial value", (Throwable)e);
            }
            customTimeEditor.addSelectionAdapter(new SelectionAdapter(this){
                final /* synthetic */ CustomTimeEditorDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.value = Optional.ofNullable(customTimeEditor.getValueAsDate()).map(v -> v.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).orElse(null);
                }
            });
            return customTimeEditor.getControl();
        }

        @Nullable
        public LocalDateTime result() {
            return this.value;
        }
    }
}

