/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.editors.erd.export.ERDExportFormatHandler;

public class ERDExportFormatRegistry {
    private static final Log log = Log.getLog(ERDExportFormatRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.ui.editors.erd.export.format";
    private static ERDExportFormatRegistry instance = null;
    private final List<FormatDescriptor> formats = new ArrayList<FormatDescriptor>();

    public static synchronized ERDExportFormatRegistry getInstance() {
        if (instance == null) {
            instance = new ERDExportFormatRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ERDExportFormatRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            FormatDescriptor formatDescriptor = new FormatDescriptor(this, ext);
            this.formats.add(formatDescriptor);
        }
    }

    public List<FormatDescriptor> getFormats() {
        return this.formats;
    }

    public class FormatDescriptor
    extends AbstractDescriptor {
        private final String extension;
        private final String label;
        private final AbstractDescriptor.ObjectType type;

        protected FormatDescriptor(ERDExportFormatRegistry this$0, IConfigurationElement config) {
            super(config);
            this.extension = config.getAttribute("ext");
            this.label = config.getAttribute("label");
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        }

        public String getExtension() {
            return this.extension;
        }

        public String getLabel() {
            return this.label;
        }

        public ERDExportFormatHandler getInstance() throws DBException {
            return (ERDExportFormatHandler)this.type.createInstance(ERDExportFormatHandler.class);
        }
    }
}

