/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.utils.CommonUtils;

public class AnnotationsInformationView {
    private static final Log log = Log.getLog(AnnotationsInformationView.class);
    private static final String QUICK_FIX_COMMAND_ID = "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals";
    private Composite linksContainer;
    private int tooltipAnchorLine = -1;
    private IRegion tooltipAnchorRegion = null;
    private boolean forceAnnotationIcon = false;
    @NotNull
    private final AbstractInformationControl container;
    @NotNull
    private final SQLEditorBase editor;
    @Nullable
    private final IQuickAssistAssistant quickAssistAssistant;
    @Nullable
    private final QuickFixCommandInfo quickFixCommandInfo;
    @NotNull
    private final IHyperlinkListener hyperlinkListener = new ContextfulHyperlinkListener(){

        @Override
        void navigateLink(AnnotationHyperlinkInfo hyperlink) {
            hyperlink.open(AnnotationsInformationView.this.editor);
        }
    };
    @NotNull
    private final IHyperlinkListener fixHyperlinkListener = new ContextfulHyperlinkListener(){

        @Override
        void navigateLink(AnnotationHyperlinkInfo hyperlink) {
            hyperlink.quickFix(AnnotationsInformationView.this.editor);
        }
    };

    public AnnotationsInformationView(@NotNull AbstractInformationControl container, @NotNull SQLEditorBase editor) {
        this.container = container;
        this.editor = editor;
        this.quickAssistAssistant = this.editor.getViewer() != null ? this.editor.getViewer().getQuickAssistAssistant() : null;
        this.quickFixCommandInfo = AnnotationsInformationView.obtainQuickFixCommandInfo((IServiceLocator)editor.getEditorSite());
    }

    public Control createControl(@NotNull Composite parent) {
        this.linksContainer = UIUtils.createComposite((Composite)parent, (int)1);
        return this.linksContainer;
    }

    public void setForceAnnotationIcon(boolean value) {
        this.forceAnnotationIcon = value;
    }

    public void setLinksInformation(@NotNull AnnotationsHoverInfo hoverInfo) {
        this.tooltipAnchorLine = hoverInfo.tooltipAnchorLine;
        this.tooltipAnchorRegion = hoverInfo.hoverRegion;
        if (hoverInfo.annotationsGroups().isEmpty()) {
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(0, 0).margins(0, 0).create());
        } else {
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            for (AnnotationsGroupInfo annotationGroup : hoverInfo.annotationsGroups()) {
                Composite linksGroupContainer;
                if (hoverInfo.annotationsGroups().size() > 1 || this.forceAnnotationIcon) {
                    linksGroupContainer = UIUtils.createComposite((Composite)this.linksContainer, (int)2);
                    DBIcon icon = annotationGroup.getIcon();
                    if (icon != null) {
                        UIUtils.createLabel((Composite)linksGroupContainer, (DBPImage)icon);
                    } else {
                        UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)1);
                    }
                } else {
                    linksGroupContainer = this.linksContainer;
                }
                List<AnnotationHyperlinkInfo> hyperlinks = annotationGroup.getAnnotations();
                assert (!hyperlinks.isEmpty());
                int alsoLinksLimit = 5;
                int alsoLinksToShow = Math.min(5, hyperlinks.size() - 1) + 1;
                Composite groupLinksContainer = UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)(hyperlinks.size() == 1 ? 1 : alsoLinksToShow * 2 + 1), (int)0);
                this.createHyperlinkControl(groupLinksContainer, hyperlinks.getFirst(), annotationGroup.getMessage());
                if (hyperlinks.size() <= 2) continue;
                UIUtils.createLabel((Composite)groupLinksContainer, (String)" (also at position ");
                for (int i = 1; i < alsoLinksToShow; ++i) {
                    AnnotationHyperlinkInfo hyperlink = hyperlinks.get(i);
                    if (i > 1) {
                        UIUtils.createLabel((Composite)groupLinksContainer, (String)", ");
                    }
                    this.createHyperlinkControl(groupLinksContainer, hyperlink, Integer.toString(hyperlink.position().getOffset()));
                }
                UIUtils.createLabel((Composite)groupLinksContainer, (String)(hyperlinks.size() <= 5 ? ")" : ", ... " + hyperlinks.size() + " such problems in line)"));
            }
        }
        this.container.getShell().pack(true);
    }

    public void show() {
        if ((this.tooltipAnchorLine >= 0 || this.tooltipAnchorRegion != null) && this.editor.getDocument() != null && this.editor.getTextViewer() != null) {
            try {
                IRegion modelLineRange = this.tooltipAnchorRegion != null ? this.tooltipAnchorRegion : this.editor.getDocument().getLineInformation(this.tooltipAnchorLine);
                IRegion visualLineRange = this.editor.getTextViewer().modelRange2WidgetRange(modelLineRange);
                StyledText widget = this.editor.getTextViewer().getTextWidget();
                int offset = visualLineRange.getOffset();
                int length = visualLineRange.getLength();
                Rectangle localLineBounds = widget.getTextBounds(offset, offset + (length > 0 ? length - 1 : length));
                Rectangle globalLineBounds = Geometry.toDisplay((Control)widget, (Rectangle)localLineBounds);
                Rectangle globalWidgetBounds = Geometry.toDisplay((Control)widget, (Rectangle)widget.getBounds());
                int y = Math.min(globalLineBounds.y + globalLineBounds.height, globalWidgetBounds.y + globalWidgetBounds.height - widget.getHorizontalBar().getSize().y);
                Shell shell = this.container.getShell();
                boolean hasTooltipRanAway = !globalWidgetBounds.intersects(shell.getBounds());
                Rectangle adjustedBounds = new Rectangle(globalLineBounds.x, y, globalLineBounds.width, globalLineBounds.height);
                if (shell.getBounds().intersects(adjustedBounds) || hasTooltipRanAway || this.tooltipAnchorRegion != null) {
                    int x = hasTooltipRanAway || this.tooltipAnchorRegion != null ? Math.min(widget.getDisplay().getCursorLocation().x, globalLineBounds.x) : shell.getBounds().x;
                    shell.setLocation(new Point(x, y));
                }
                shell.pack(true);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void createHyperlinkControl(@NotNull Composite groupLinksContainer, @NotNull AnnotationHyperlinkInfo hyperlink, @NotNull String text) {
        SQLSemanticErrorAnnotation s;
        String underlyingError;
        Composite linkContainer = new Composite(groupLinksContainer, 0);
        linkContainer.setLayout((Layout)RowLayoutFactory.fillDefaults().spacing(0).create());
        Hyperlink link = new Hyperlink(linkContainer, 0);
        link.setHref((Object)hyperlink);
        link.setText(text);
        link.setUnderlined(true);
        link.addHyperlinkListener(this.hyperlinkListener);
        Annotation annotation = hyperlink.annotation();
        if (annotation instanceof SQLSemanticErrorAnnotation && CommonUtils.isNotEmpty((String)(underlyingError = (s = (SQLSemanticErrorAnnotation)annotation).getUnderlyingErrorMessage()))) {
            link.setToolTipText(underlyingError);
        }
        if (this.quickFixCommandInfo != null && this.quickAssistAssistant != null && this.quickAssistAssistant.canFix(hyperlink.annotation)) {
            UIUtils.createLabel((Composite)linkContainer, (String)" (");
            Hyperlink fixLink = new Hyperlink(linkContainer, 0);
            fixLink.setHref((Object)hyperlink);
            fixLink.setText(this.quickFixCommandInfo.name);
            fixLink.setUnderlined(true);
            fixLink.addHyperlinkListener(this.fixHyperlinkListener);
            fixLink.setToolTipText(this.quickFixCommandInfo.description);
            UIUtils.createLabel((Composite)linkContainer, (String)")");
        }
    }

    @Nullable
    private static QuickFixCommandInfo obtainQuickFixCommandInfo(@NotNull IServiceLocator site) {
        String description;
        String name;
        Command command = ActionUtils.findCommand((String)QUICK_FIX_COMMAND_ID);
        if (command == null) {
            log.error((Object)"Failed to resolve command by id 'org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals'");
            return null;
        }
        try {
            name = command.getName();
            description = command.getDescription();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to resolve command parameters for unknown command 'org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals'", e);
            return null;
        }
        String shortcut = ActionUtils.findCommandDescription((String)QUICK_FIX_COMMAND_ID, (IServiceLocator)site, (boolean)true);
        if (CommonUtils.isNotEmpty((String)shortcut)) {
            description = CommonUtils.isNotEmpty((String)description) ? description + " (" + shortcut + ")" : shortcut;
        }
        return new QuickFixCommandInfo(name, description);
    }

    private record QuickFixCommandInfo(@NotNull String name, @NotNull String description) {
    }

    public record AnnotationsHoverInfo(@NotNull List<AnnotationsGroupInfo> annotationsGroups, @Nullable IRegion hoverRegion, int tooltipAnchorLine) {
    }

    public static class AnnotationsGroupInfo {
        private static final Position MIN_POSITION = new Position(0, 0);
        private static final Position MAX_POSITION = new Position(Integer.MAX_VALUE, 0);
        private static final int UNKNOWN_SEVERITY = -1;
        @NotNull
        private final List<AnnotationHyperlinkInfo> annotations = new ArrayList<AnnotationHyperlinkInfo>();
        @NotNull
        private final String message;
        @NotNull
        private Position firstPosition = MAX_POSITION;
        @NotNull
        private Position lastPosition = MIN_POSITION;
        private int severity = -1;

        public AnnotationsGroupInfo(@NotNull String message) {
            this.message = message;
        }

        public void add(@NotNull Annotation anno, @NotNull Position annoPosition) {
            Position firstPos = this.firstPosition;
            if (firstPos.offset > annoPosition.offset) {
                this.firstPosition = annoPosition;
            }
            Position lastPos = this.lastPosition;
            if (lastPos.offset + lastPos.length < annoPosition.offset + annoPosition.length) {
                this.lastPosition = annoPosition;
            }
            AnnotationHyperlinkInfo entry = new AnnotationHyperlinkInfo(anno, annoPosition);
            STMUtils.orderedInsert(this.annotations, e -> e.position().getOffset(), (Object)entry, Integer::compare);
            this.severity = Math.max(this.severity, this.getAnnotationSeverity(anno));
        }

        @NotNull
        public List<AnnotationHyperlinkInfo> getAnnotations() {
            return this.annotations;
        }

        @NotNull
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public Position getFirstPosition() {
            return this.firstPosition;
        }

        @NotNull
        public Position getLastPosition() {
            return this.lastPosition;
        }

        @Nullable
        public DBIcon getIcon() {
            return switch (this.severity) {
                case 2 -> DBIcon.SMALL_ERROR;
                case 1 -> DBIcon.SMALL_WARNING;
                case 0 -> DBIcon.SMALL_INFO;
                default -> null;
            };
        }

        private int getAnnotationSeverity(@NotNull Annotation anno) {
            if (anno instanceof MarkerAnnotation) {
                MarkerAnnotation ma = (MarkerAnnotation)anno;
                try {
                    int n;
                    Object object = ma.getMarker().getAttribute("severity");
                    if (object instanceof Integer) {
                        Integer n2 = (Integer)object;
                        n = n2;
                    } else {
                        n = 0;
                    }
                    return n;
                }
                catch (CoreException e) {
                    log.error((Object)"Failed to obtain annotation severity icon", (Throwable)e);
                    return -1;
                }
            }
            return 0;
        }
    }

    public record AnnotationHyperlinkInfo(@NotNull Annotation annotation, @NotNull Position position) {
        public void open(@NotNull SQLEditorBase editor) {
            TextViewer textViewer = editor.getTextViewer();
            if (textViewer != null && !this.position.isDeleted) {
                textViewer.setSelectedRange(this.position.getOffset(), this.position.getLength());
                textViewer.revealRange(this.position.getOffset(), this.position.getLength());
                textViewer.getTextWidget().setFocus();
            }
        }

        public void quickFix(@NotNull SQLEditorBase editor) {
            if (!this.position.isDeleted) {
                editor.selectAndReveal(this.position.getOffset(), 0);
                UIUtils.asyncExec(() -> ActionUtils.runCommand((String)AnnotationsInformationView.QUICK_FIX_COMMAND_ID, (ISelection)editor.getSelectionProvider().getSelection(), (IServiceLocator)editor.getSite()));
            }
        }
    }

    private abstract class ContextfulHyperlinkListener
    implements IHyperlinkListener {
        private Point oldSelection = null;

        private ContextfulHyperlinkListener() {
        }

        public final void linkEntered(@NotNull HyperlinkEvent e) {
            Object object = e.getHref();
            if (object instanceof AnnotationHyperlinkInfo) {
                AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                this.oldSelection = AnnotationsInformationView.this.editor.getTextViewer() != null ? AnnotationsInformationView.this.editor.getTextViewer().getSelectedRange() : null;
                Position hyperlinkRegion = hyperlink.position();
                if (!hyperlinkRegion.isDeleted) {
                    AnnotationsInformationView.this.editor.getTextViewer().setSelectedRange(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength());
                }
            }
        }

        public final void linkExited(@NotNull HyperlinkEvent e) {
            if (this.oldSelection != null && AnnotationsInformationView.this.editor.getTextViewer() != null) {
                AnnotationsInformationView.this.editor.getTextViewer().setSelectedRange(this.oldSelection.x, this.oldSelection.y);
                this.oldSelection = null;
            }
        }

        public final void linkActivated(HyperlinkEvent e) {
            Object object = e.getHref();
            if (object instanceof AnnotationHyperlinkInfo) {
                AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                this.navigateLinkInternal(hyperlink);
            }
        }

        private void navigateLinkInternal(AnnotationHyperlinkInfo hyperlink) {
            this.oldSelection = null;
            this.navigateLink(hyperlink);
        }

        abstract void navigateLink(AnnotationHyperlinkInfo var1);
    }
}

