/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LineHistoryMapper {
    private static final Logger LOG = Logger.getInstance(LineHistoryMapper.class);
    private final Object myLock = new Object();
    private final Project myProject;
    private final VirtualFile myFile;
    private final Document myDocument;
    private final long myDate;
    private SoftReference<Int2IntMap> myNewToOldLines;
    private SoftReference<Int2IntMap> myOldToNewLines;
    private volatile SoftReference<byte[]> myOldContent;

    LineHistoryMapper(Project project, VirtualFile file, Document document, long date) {
        this.myProject = project;
        this.myFile = file;
        this.myDocument = document;
        this.myDate = date;
    }

    public long getTimeStamp() {
        return this.myDate;
    }

    public void clear() {
        this.myNewToOldLines = null;
        this.myOldToNewLines = null;
    }

    public boolean canGetFastMapping() {
        return this.myOldContent != null;
    }

    @Nullable
    public Int2IntMap getOldToNewLineMapping() {
        if (this.myOldToNewLines == null) {
            this.myOldToNewLines = this.doGetLineMapping(true);
            if (this.myOldToNewLines == null) {
                return null;
            }
        }
        return this.myOldToNewLines.get();
    }

    @Nullable
    public Int2IntMap getNewToOldLineMapping() {
        if (this.myNewToOldLines == null) {
            this.myNewToOldLines = this.doGetLineMapping(false);
            if (this.myNewToOldLines == null) {
                return null;
            }
        }
        return this.myNewToOldLines.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SoftReference<Int2IntMap> doGetLineMapping(boolean oldToNew) {
        Diff.Change change;
        byte[] oldContent;
        if (this.myOldContent == null && ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myOldContent == null) {
                byte[] byteContent = this.loadFromLocalHistory();
                if (byteContent == null && this.myFile.getTimeStamp() > this.myDate) {
                    byteContent = this.loadFromVersionControl();
                }
                this.myOldContent = new SoftReference<byte[]>(byteContent);
            }
            oldContent = this.myOldContent.get();
        }
        if (oldContent == null) {
            return new SoftReference<Object>(null);
        }
        Object[] historyLines = this.getLinesFromBytes(oldContent);
        Object[] currentLines = this.getUpToDateLines();
        Object[] oldLines = oldToNew ? historyLines : currentLines;
        Object[] newLines = oldToNew ? currentLines : historyLines;
        try {
            change = Diff.buildChanges((Object[])oldLines, (Object[])newLines);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
            return new SoftReference<Object>(null);
        }
        return new SoftReference<Int2IntMap>(LineHistoryMapper.buildMapping(change, oldLines.length));
    }

    private byte @Nullable [] loadFromLocalHistory() {
        return LocalHistory.getInstance().getByteContent(this.myFile, t -> t < this.myDate);
    }

    private byte @Nullable [] loadFromVersionControl() {
        try {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)this.myFile);
            if (vcs == null) {
                return null;
            }
            VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
            if (historyProvider == null) {
                return null;
            }
            FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(this.myFile);
            VcsHistorySession session = historyProvider.createSessionFor(filePath);
            if (session == null) {
                return null;
            }
            List list = session.getRevisionList();
            if (list == null) {
                return null;
            }
            for (VcsFileRevision revision : list) {
                Date revisionDate = revision.getRevisionDate();
                if (revisionDate == null) {
                    return null;
                }
                if (revisionDate.getTime() >= this.myDate) continue;
                return revision.loadContent();
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    private String @NotNull [] getLinesFromBytes(byte @NotNull [] oldContent) {
        String[] stringArray;
        AccessToken ignore;
        block7: {
            if (oldContent == null) {
                LineHistoryMapper.$$$reportNull$$$0(0);
            }
            ignore = ProjectLocator.withPreferredProject((VirtualFile)this.myFile, (Project)this.myProject);
            String text = LoadTextUtil.getTextByBinaryPresentation((byte[])oldContent, (VirtualFile)this.myFile, (boolean)false, (boolean)false).toString();
            stringArray = LineTokenizer.tokenize((CharSequence)text, (boolean)false);
            if (stringArray != null) break block7;
            LineHistoryMapper.$$$reportNull$$$0(1);
        }
        return stringArray;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    private String @NotNull [] getUpToDateLines() {
        String[] stringArray = (String[])ReadAction.compute(() -> {
            int lineCount = this.myDocument.getLineCount();
            String[] lines = new String[lineCount];
            CharSequence chars = this.myDocument.getCharsSequence();
            for (int i = 0; i < lineCount; ++i) {
                lines[i] = chars.subSequence(this.myDocument.getLineStartOffset(i), this.myDocument.getLineEndOffset(i)).toString();
            }
            return lines;
        });
        if (stringArray == null) {
            LineHistoryMapper.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static Int2IntMap buildMapping(Diff.Change change, int firstNLines) {
        Int2IntOpenHashMap result = new Int2IntOpenHashMap();
        int prevLineInFirst = 0;
        int prevLineInSecond = 0;
        while (change != null) {
            for (int l = 0; l < change.line0 - prevLineInFirst; ++l) {
                result.put(prevLineInFirst + l, prevLineInSecond + l);
            }
            prevLineInFirst = change.line0 + change.deleted;
            prevLineInSecond = change.line1 + change.inserted;
            change = change.link;
        }
        for (int i = prevLineInFirst; i < firstNLines; ++i) {
            result.put(i, prevLineInSecond + i - prevLineInFirst);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/LineHistoryMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/LineHistoryMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesFromBytes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpToDateLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLinesFromBytes";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

