/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.JumpInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.data.instructions.SwitchInstructions;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.util.ClassListSection;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionsSection
extends ClassListSection {
    final ProjectData myProjectData;

    /*
     * WARNING - void declaration
     */
    public InstructionsSection(ProjectData projectData) {
        void var1_1;
        this.myProjectData = var1_1;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEngaged(ProjectData projectData, InstrumentationOptions options) {
        void var1_1;
        return options.isBranchCoverage && var1_1.isInstructionsCoverageEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict, int version) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        projectData.setInstructionsCoverage(true);
        super.load((ProjectData)var1_1, (DataInputStream)var2_2, (TIntObjectHashMap<ClassData>)var3_3, version);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadClass(DataInputStream in, ClassData classData, int version) throws IOException {
        void var2_2;
        void var3_4;
        LineData[] lines = (LineData[])classData.getLines();
        LineInstructions[] instructions = new LineInstructions[lines.length];
        for (void lineData : var3_4) {
            int i;
            LineInstructions lineInstructions;
            if (lineData == null) continue;
            instructions[lineData.getLineNumber()] = lineInstructions = new LineInstructions();
            lineInstructions.setInstructions(CoverageIOUtil.readINT(in));
            for (i = 0; i < lineData.jumpsCount(); ++i) {
                JumpInstructions jump = new JumpInstructions();
                lineInstructions.addJump(jump);
                jump.setInstructions(true, CoverageIOUtil.readINT(in));
                jump.setInstructions(false, CoverageIOUtil.readINT(in));
            }
            for (i = 0; i < lineData.switchesCount(); ++i) {
                SwitchData jump = lineData.getSwitchData(i);
                int size = jump.getKeys().length;
                SwitchInstructions switchInstructions = new SwitchInstructions(size);
                lineInstructions.addSwitch(switchInstructions);
                for (int key = -1; key < size; ++key) {
                    switchInstructions.setInstructions(key, CoverageIOUtil.readINT(in));
                }
            }
        }
        this.myProjectData.getInstructions().put(var2_2.getName(), new ClassInstructions(instructions));
    }

    @Override
    protected void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        int lineCount;
        LineData[] lines = (LineData[])classData.getLines();
        if (lines == null) {
            return;
        }
        LineData[] classInstructions = this.myProjectData.getInstructions().get(classData.getName());
        if (classInstructions == null) {
            lineCount = 0;
            classInstructions = lines;
            int n = lines.length;
            for (int i = 0; i < n; ++i) {
                LineData lineData = classInstructions[i];
                if (lineData == null) continue;
                ++lineCount;
            }
            ErrorReporter.info("Class " + classData.getName() + " does not have instructions info, while there are " + lineCount + " lines available", new Throwable());
            return;
        }
        CoverageIOUtil.writeINT(out, lineCount);
        LineInstructions[] lineInstructions = classInstructions.getlines();
        for (int line = 0; line < lines.length; ++line) {
            LineData lineData = lines[line];
            if (lineData == null) continue;
            LineInstructions lineInstruction = line >= lineInstructions.length ? null : lineInstructions[line];
            CoverageIOUtil.writeINT(out, lineInstruction == null ? 0 : lineInstruction.getInstructions());
            List<JumpInstructions> jumps = lineInstruction == null ? null : lineInstruction.getJumps();
            for (int i = 0; i < lineData.jumpsCount(); ++i) {
                JumpInstructions jumpInstructions = jumps == null || i >= jumps.size() ? null : jumps.get(i);
                CoverageIOUtil.writeINT(out, jumpInstructions == null ? 0 : jumpInstructions.getInstructions(true));
                CoverageIOUtil.writeINT(out, jumpInstructions == null ? 0 : jumpInstructions.getInstructions(false));
            }
            List<SwitchInstructions> switches = lineInstruction == null ? null : lineInstruction.getSwitches();
            for (int i = 0; i < lineData.switchesCount(); ++i) {
                SwitchInstructions switchInstructions = switches == null || i >= switches.size() ? null : switches.get(i);
                for (int key = -1; key < lineData.getSwitchData(i).getKeys().length; ++key) {
                    CoverageIOUtil.writeINT(out, switchInstructions == null ? 0 : switchInstructions.getInstructions(key));
                }
            }
        }
    }
}

