/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.Utils;

public class Proto
implements ExternalizableGraphElement {
    private final JVMFlags access;
    private final String signature;
    private final String name;
    @NotNull
    private final Iterable<ElementAnnotation> annotations;

    public Proto(@NotNull JVMFlags flags, String signature, String name, @NotNull Iterable<ElementAnnotation> annotations) {
        if (flags == null) {
            Proto.$$$reportNull$$$0(0);
        }
        if (annotations == null) {
            Proto.$$$reportNull$$$0(1);
        }
        this.access = flags;
        this.signature = signature == null ? "" : signature;
        this.name = name == null ? "" : name;
        this.annotations = annotations;
    }

    public Proto(GraphDataInput in) throws IOException {
        this.access = new JVMFlags(in.readInt());
        this.signature = in.readUTF();
        this.name = in.readUTF();
        this.annotations = RW.readCollection(in, () -> new ElementAnnotation(in));
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeInt(this.access.getValue());
        out.writeUTF(this.signature);
        out.writeUTF(this.name);
        RW.writeCollection(out, this.annotations, t -> t.write(out));
    }

    public final JVMFlags getFlags() {
        return this.access;
    }

    public final String getSignature() {
        return this.signature;
    }

    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Iterable<ElementAnnotation> getAnnotations() {
        Iterable<ElementAnnotation> iterable = this.annotations;
        if (iterable == null) {
            Proto.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    public final boolean isPublic() {
        return this.getFlags().isPublic();
    }

    public final boolean isProtected() {
        return this.getFlags().isProtected();
    }

    public final boolean isPackageLocal() {
        return this.getFlags().isPackageLocal();
    }

    public final boolean isPrivate() {
        return this.getFlags().isPrivate();
    }

    public final boolean isAbstract() {
        return this.getFlags().isAbstract();
    }

    public final boolean isBridge() {
        return this.getFlags().isBridge();
    }

    public final boolean isSynthetic() {
        return this.getFlags().isSynthetic();
    }

    public final boolean isAnnotation() {
        return this.getFlags().isAnnotation();
    }

    public final boolean isFinal() {
        return this.getFlags().isFinal();
    }

    public final boolean isStatic() {
        return this.getFlags().isStatic();
    }

    public boolean isLibrary() {
        return this.getFlags().isLibrary();
    }

    public final boolean isMoreAccessibleThan(Proto anotherProto) {
        if (anotherProto.isPrivate()) {
            return this.isPackageLocal() || this.isProtected() || this.isPublic();
        }
        if (anotherProto.isPackageLocal()) {
            return this.isProtected() || this.isPublic();
        }
        if (anotherProto.isProtected()) {
            return this.isPublic();
        }
        return false;
    }

    public final boolean isWeakerAccessThan(Proto anotherProto) {
        return this.getFlags().isWeakerAccess(anotherProto.getFlags());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/Proto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/Proto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Diff<V extends Proto>
    implements Difference {
        private final Supplier<Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff>> myAnnotationsDiff;
        protected final V myPast;
        final /* synthetic */ Proto this$0;

        public Diff(V past) {
            this.this$0 = this$0;
            this.myPast = past;
            this.myAnnotationsDiff = Utils.lazyValue(() -> Difference.deepDiff(((Proto)this.myPast).getAnnotations(), this.this$0.getAnnotations()));
        }

        @Override
        public boolean unchanged() {
            return !this.flagsChanged() && !this.signatureChanged() && this.annotations().unchanged();
        }

        public boolean flagsChanged() {
            return !((Proto)this.myPast).getFlags().equals(this.this$0.getFlags());
        }

        public JVMFlags getAddedFlags() {
            return this.this$0.getFlags().deriveAdded(((Proto)this.myPast).getFlags());
        }

        public JVMFlags getRemovedFlags() {
            return this.this$0.getFlags().deriveRemoved(((Proto)this.myPast).getFlags());
        }

        public boolean becamePackageLocal() {
            return !((Proto)this.myPast).isPackageLocal() && this.this$0.isPackageLocal();
        }

        public boolean accessRestricted() {
            return this.this$0.isWeakerAccessThan((Proto)this.myPast);
        }

        public boolean accessExpanded() {
            return ((Proto)this.myPast).isWeakerAccessThan(this.this$0);
        }

        public boolean signatureChanged() {
            return !Objects.equals(((Proto)this.myPast).getSignature(), this.this$0.getSignature());
        }

        public Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotations() {
            return this.myAnnotationsDiff.get();
        }
    }
}

