/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class HllFieldData
implements IndexFieldData<HllLeafFieldData> {
    private final String fieldName;
    private final int precision;

    private HllFieldData(String fieldName, int precision) {
        this.fieldName = fieldName;
        this.precision = precision;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    @Override
    public HllLeafFieldData load(LeafReaderContext context) {
        return new HllLeafFieldData(context.reader(), this.fieldName);
    }

    @Override
    public HllLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("Sorting is not supported on [hll] fields");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("Bucketed sort is not supported on [hll] fields");
    }

    public static class HllLeafFieldData
    implements LeafFieldData {
        private final LeafReader reader;
        private final String fieldName;

        HllLeafFieldData(LeafReader reader, String fieldName) {
            this.reader = reader;
            this.fieldName = fieldName;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public void close() {
        }

        @Override
        public ScriptDocValues<?> getScriptValues() {
            throw new UnsupportedOperationException("HLL fields do not support getScriptValues");
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            throw new UnsupportedOperationException("HLL fields do not support getBytesValues");
        }

        public AbstractHyperLogLogPlusPlus getSketch(int docId) throws IOException {
            BinaryDocValues docValues = this.reader.getBinaryDocValues(this.fieldName);
            if (docValues != null && docValues.advanceExact(docId)) {
                BytesRef sketchBytes = docValues.binaryValue();
                return AbstractHyperLogLogPlusPlus.readFrom(new BytesArray(sketchBytes.bytes, sketchBytes.offset, sketchBytes.length).streamInput(), BigArrays.NON_RECYCLING_INSTANCE);
            }
            return null;
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final int precision;

        public Builder(String name, int precision) {
            this.name = name;
            this.precision = precision;
        }

        public HllFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new HllFieldData(this.name, this.precision);
        }
    }
}

