/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.network.CloseableChannel;
import org.opensearch.common.transport.NetworkExceptionHelper;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.NotifyOnceListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TransportLogger;

public final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;

    public OutboundHandler(StatsTracker statsTracker, ThreadPool threadPool) {
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        SendContext sendContext = new SendContext(this.statsTracker, channel, (CheckedSupplier<BytesReference, IOException>)((CheckedSupplier)() -> bytes), listener);
        try {
            this.sendBytes(channel, sendContext);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void sendBytes(long requestId, TcpChannel channel, SendContext sendContext) throws IOException {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        BytesReference reference = sendContext.get();
        try (ThreadContext.StoredContext existing = this.threadPool.getThreadContext().stashContext();){
            if (requestId == -1L) {
                channel.sendMessage(reference, (ActionListener<Void>)sendContext);
            } else {
                channel.sendMessage(requestId, reference, (ActionListener<Void>)sendContext);
            }
        }
        catch (RuntimeException ex) {
            sendContext.onFailure(ex);
            CloseableChannel.closeChannel(channel);
            throw ex;
        }
    }

    public void sendBytes(TcpChannel channel, SendContext sendContext) throws IOException {
        this.sendBytes(-1L, channel, sendContext);
    }

    public static class SendContext
    extends NotifyOnceListener<Void>
    implements CheckedSupplier<BytesReference, IOException> {
        private final StatsTracker statsTracker;
        private final TcpChannel channel;
        private final CheckedSupplier<BytesReference, IOException> messageSupplier;
        private final ActionListener<Void> listener;
        private final Releasable optionalReleasable;
        private long messageSize = -1L;

        SendContext(StatsTracker statsTracker, TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener) {
            this(statsTracker, channel, messageSupplier, listener, null);
        }

        public SendContext(StatsTracker statsTracker, TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener, Releasable optionalReleasable) {
            this.channel = channel;
            this.messageSupplier = messageSupplier;
            this.listener = listener;
            this.optionalReleasable = optionalReleasable;
            this.statsTracker = statsTracker;
        }

        public BytesReference get() throws IOException {
            try {
                BytesReference message = (BytesReference)this.messageSupplier.get();
                this.messageSize = message.length();
                TransportLogger.logOutboundMessage(this.channel, message);
                return message;
            }
            catch (Exception e) {
                this.onFailure(e);
                throw e;
            }
        }

        protected void innerOnResponse(Void v) {
            assert (this.messageSize != -1L) : "If onResponse is being called, the message should have been serialized";
            this.statsTracker.markBytesWritten(this.messageSize);
            this.closeAndCallback(() -> this.listener.onResponse((Object)v));
        }

        protected void innerOnFailure(Exception e) {
            if (NetworkExceptionHelper.isCloseConnectionException((Throwable)e)) {
                logger.debug(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            } else {
                logger.warn(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            }
            this.closeAndCallback(() -> this.listener.onFailure(e));
        }

        private void closeAndCallback(Runnable runnable) {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = this.optionalReleasable;
            releasableArray[1] = runnable::run;
            Releasables.close((Releasable[])releasableArray);
        }
    }
}

