/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.extractor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.extractor.AbstractEmbeddedDocumentBytesHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.emitter.Emitter;
import org.apache.tika.pipes.emitter.EmitterManager;
import org.apache.tika.pipes.emitter.StreamEmitter;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.pipes.extractor.EmbeddedDocumentBytesConfig;

public class EmittingEmbeddedDocumentBytesHandler
extends AbstractEmbeddedDocumentBytesHandler {
    private final EmitKey containerEmitKey;
    private final EmbeddedDocumentBytesConfig embeddedDocumentBytesConfig;
    private final StreamEmitter emitter;
    private static final Metadata METADATA = new Metadata();
    private static final ParseContext PARSE_CONTEXT = new ParseContext();

    public EmittingEmbeddedDocumentBytesHandler(FetchEmitTuple fetchEmitTuple, EmitterManager emitterManager) throws TikaConfigException {
        this.containerEmitKey = fetchEmitTuple.getEmitKey();
        this.embeddedDocumentBytesConfig = fetchEmitTuple.getParseContext().get(EmbeddedDocumentBytesConfig.class);
        if (this.embeddedDocumentBytesConfig == null) {
            throw new TikaConfigException("EmbeddedDocumentBytesConfig must not be null!");
        }
        Emitter tmpEmitter = emitterManager.getEmitter(this.embeddedDocumentBytesConfig.getEmitter());
        if (!(tmpEmitter instanceof StreamEmitter)) {
            throw new TikaConfigException("Emitter " + this.embeddedDocumentBytesConfig.getEmitter() + " must implement a StreamEmitter");
        }
        this.emitter = (StreamEmitter)tmpEmitter;
    }

    @Override
    public void add(int id, Metadata metadata, InputStream inputStream) throws IOException {
        String emitKey = this.getEmitKey(this.containerEmitKey.getEmitKey(), id, this.embeddedDocumentBytesConfig, metadata);
        try {
            this.emitter.emit(emitKey, inputStream, METADATA, PARSE_CONTEXT);
        }
        catch (TikaEmitterException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.emitter instanceof Closeable) {
            ((Closeable)((Object)this.emitter)).close();
        }
    }
}

