/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.CreateControllerResponse;
import org.opensearch.client.opensearch.ml.RateLimiter;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateControllerRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateControllerRequest> {
    @Nonnull
    private final String modelId;
    @Nonnull
    private final Map<String, RateLimiter> userRateLimiter;
    public static final JsonpDeserializer<CreateControllerRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateControllerRequest::setupCreateControllerRequestDeserializer);
    public static final Endpoint<CreateControllerRequest, CreateControllerResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateControllerRequest, CreateControllerResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/controllers/");
        SimpleEndpoint.pathEncode(request.modelId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateControllerResponse._DESERIALIZER);

    private CreateControllerRequest(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.userRateLimiter = ApiTypeHelper.unmodifiable(builder.userRateLimiter);
    }

    public static CreateControllerRequest of(Function<Builder, ObjectBuilder<CreateControllerRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Nonnull
    public final Map<String, RateLimiter> userRateLimiter() {
        return this.userRateLimiter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.userRateLimiter)) {
            generator.writeKey("user_rate_limiter");
            generator.writeStartObject();
            for (Map.Entry<String, RateLimiter> item0 : this.userRateLimiter.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateControllerRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::userRateLimiter, JsonpDeserializer.stringMapDeserializer(RateLimiter._DESERIALIZER), "user_rate_limiter");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.modelId.hashCode();
        result = 31 * result + Objects.hashCode(this.userRateLimiter);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateControllerRequest other = (CreateControllerRequest)o;
        return this.modelId.equals(other.modelId) && Objects.equals(this.userRateLimiter, other.userRateLimiter);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateControllerRequest> {
        private String modelId;
        @Nullable
        private Map<String, RateLimiter> userRateLimiter;

        public Builder() {
        }

        private Builder(CreateControllerRequest o) {
            super(o);
            this.modelId = o.modelId;
            this.userRateLimiter = Builder._mapCopy(o.userRateLimiter);
        }

        private Builder(Builder o) {
            super(o);
            this.modelId = o.modelId;
            this.userRateLimiter = Builder._mapCopy(o.userRateLimiter);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder userRateLimiter(Map<String, RateLimiter> map) {
            this.userRateLimiter = Builder._mapPutAll(this.userRateLimiter, map);
            return this;
        }

        @Nonnull
        public final Builder userRateLimiter(String key, RateLimiter value) {
            this.userRateLimiter = Builder._mapPut(this.userRateLimiter, key, value);
            return this;
        }

        @Nonnull
        public final Builder userRateLimiter(String key, Function<RateLimiter.Builder, ObjectBuilder<RateLimiter>> fn) {
            return this.userRateLimiter(key, fn.apply(new RateLimiter.Builder()).build());
        }

        @Override
        @Nonnull
        public CreateControllerRequest build() {
            this._checkSingleUse();
            return new CreateControllerRequest(this);
        }
    }
}

