/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.RawPathHandle;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.ProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FinalizedProvidedReplica
extends ProvidedReplica {
    public FinalizedProvidedReplica(long blockId, URI fileURI, long fileOffset, long blockLen, long genStamp, PathHandle pathHandle, FsVolumeSpi volume, Configuration conf, FileSystem remoteFS) {
        super(blockId, fileURI, fileOffset, blockLen, genStamp, pathHandle, volume, conf, remoteFS);
    }

    public FinalizedProvidedReplica(FileRegion fileRegion, FsVolumeSpi volume, Configuration conf, FileSystem remoteFS) {
        super(fileRegion.getBlock().getBlockId(), fileRegion.getProvidedStorageLocation().getPath().toUri(), fileRegion.getProvidedStorageLocation().getOffset(), fileRegion.getBlock().getNumBytes(), fileRegion.getBlock().getGenerationStamp(), (PathHandle)new RawPathHandle(ByteBuffer.wrap(fileRegion.getProvidedStorageLocation().getNonce())), volume, conf, remoteFS);
    }

    public FinalizedProvidedReplica(long blockId, Path pathPrefix, String pathSuffix, long fileOffset, long blockLen, long genStamp, PathHandle pathHandle, FsVolumeSpi volume, Configuration conf, FileSystem remoteFS) {
        super(blockId, pathPrefix, pathSuffix, fileOffset, blockLen, genStamp, pathHandle, volume, conf, remoteFS);
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    @Override
    public long getBytesOnDisk() {
        return this.getNumBytes();
    }

    @Override
    public long getVisibleLength() {
        return this.getNumBytes();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public ReplicaInfo getOriginalReplica() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getOriginalReplica");
    }

    @Override
    public long getRecoveryID() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getRecoveryID");
    }

    @Override
    public void setRecoveryID(long recoveryId) {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support setRecoveryID");
    }

    @Override
    public ReplicaRecoveryInfo createInfo() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support createInfo");
    }
}

