/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.HilbertIndexMasks;
import com.google.uzaygezen.core.MultiDimensionalSpec;
import com.google.uzaygezen.core.SpaceFillingCurve;
import com.google.uzaygezen.core.ZoomingNavigator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CompactHilbertCurve
implements SpaceFillingCurve {
    private final MultiDimensionalSpec spec;
    private final HilbertIndexMasks masks;
    private final int[] m;
    private final int n;
    private final BitVector e;
    private final BitVector mu;
    private final BitVector w;
    private final BitVector t;
    private final BitVector[] rBuffer;

    public CompactHilbertCurve(MultiDimensionalSpec spec) {
        this.spec = (MultiDimensionalSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec");
        this.masks = new HilbertIndexMasks(spec);
        this.m = Ints.toArray(spec.getBitsPerDimension());
        this.n = this.m.length;
        this.e = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
        this.mu = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
        this.w = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
        this.t = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
        this.rBuffer = this.allocateBitsForAllIterations();
    }

    public CompactHilbertCurve(int[] m) {
        this(new MultiDimensionalSpec(Ints.asList((int[])m)));
    }

    @Override
    public MultiDimensionalSpec getSpec() {
        return this.spec;
    }

    @Override
    public void index(BitVector[] p, int minLevel, BitVector index) {
        Preconditions.checkArgument((p.length == this.n ? 1 : 0) != 0, (Object)"Wrong number of elements.");
        Preconditions.checkArgument((boolean)(0 <= minLevel & minLevel <= this.spec.maxBitsPerDimension()));
        for (int i = 0; i < this.n; ++i) {
            Preconditions.checkArgument((p[i].length() <= this.m[i] ? 1 : 0) != 0, (Object)"Value too large.");
        }
        index.clear();
        int d = 0;
        int exclusiveUpperBitIndexBound = this.spec.sumBitsPerDimension();
        this.e.clear();
        int i = this.spec.maxBitsPerDimension();
        while (--i >= minLevel) {
            assert (d < this.n);
            int dimensionCount = this.masks.getCardinality(i);
            this.masks.copyMaskTo(i, d, this.mu);
            CompactHilbertCurve.copyOneBitFromEachDimension(i, p, this.w);
            BitVector r = this.rBuffer[i];
            assert (r.size() == dimensionCount);
            CompactHilbertCurve.computeCompactHilbertBits(d, this.mu, this.e, this.w, r);
            index.copySectionFrom(exclusiveUpperBitIndexBound -= dimensionCount, r);
            int oldD = d;
            d = CompactHilbertCurve.updateD(d, this.w);
            CompactHilbertCurve.updateE(oldD, this.w, this.e);
        }
        assert (minLevel != 0 | exclusiveUpperBitIndexBound == 0);
    }

    @Override
    public void indexInverse(BitVector index, BitVector[] p) {
        Preconditions.checkArgument((this.n == p.length ? 1 : 0) != 0, (Object)"p does not have the right size.");
        for (int i = 0; i < this.n; ++i) {
            p[i].clear();
        }
        int d = 0;
        int k = this.spec.sumBitsPerDimension();
        BitVector[] wAndT = new BitVector[]{this.w, this.t};
        this.e.clear();
        this.t.clear();
        int i = this.spec.maxBitsPerDimension();
        while (--i >= 0) {
            assert (d < this.n);
            this.masks.copyMaskTo(i, d, this.mu);
            BitVector r = this.rBuffer[i];
            int start = k - r.size();
            r.copyFromSection(index, start);
            assert (k == start + r.size());
            CompactHilbertCurve.computeInverseBits(d, this.mu, this.e, r, wAndT);
            CompactHilbertCurve.copyOneBitToEachDimensionWhereSet(this.t, i, p);
            int oldD = d;
            d = CompactHilbertCurve.updateD(d, this.w);
            k = start;
            CompactHilbertCurve.updateE(oldD, this.w, this.e);
        }
        assert (k == 0);
    }

    @Override
    public void accept(ZoomingNavigator visitor) {
        BitVector[] p = new BitVector[this.n];
        assert (this.n == p.length);
        for (int i = 0; i < this.n; ++i) {
            p[i] = (BitVector)BitVectorFactories.OPTIMAL.apply(this.m[i]);
        }
        BitVector index = (BitVector)BitVectorFactories.OPTIMAL.apply(this.spec.sumBitsPerDimension());
        this.e.clear();
        int d = 0;
        int k = this.spec.sumBitsPerDimension();
        this.t.clear();
        this.w.clear();
        BitVector[] wAndT = new BitVector[]{this.w, this.t};
        int mMax = this.spec.maxBitsPerDimension();
        int[] dStack = new int[mMax];
        BitVector[] eStack = new BitVector[mMax];
        for (int i = 0; i < mMax; ++i) {
            eStack[i] = (BitVector)BitVectorFactories.OPTIMAL.apply(this.n);
        }
        if (!visitor.visit(mMax, index, p)) {
            return;
        }
        if (mMax != 0) {
            this.rBuffer[mMax - 1].clear();
        }
        int[] ik = new int[2];
        int i = mMax;
        while (--i >= 0) {
            this.masks.copyMaskTo(i, d, this.mu);
            CompactHilbertCurve.computeInverseBits(d, this.mu, this.e, this.rBuffer[i], wAndT);
            CompactHilbertCurve.copyOneBitToEachDimensionWhereSet(this.t, i, p);
            dStack[i] = d;
            eStack[i].copyFrom(this.e);
            int oldD = d;
            d = CompactHilbertCurve.updateD(d, this.w);
            CompactHilbertCurve.updateE(oldD, this.w, this.e);
            index.copySectionFrom(k -= this.masks.getCardinality(i), this.rBuffer[i]);
            boolean wantsChildren = visitor.visit(i, index, p);
            if (wantsChildren & i != 0) {
                this.rBuffer[i - 1].clear();
                continue;
            }
            ik[0] = i;
            ik[1] = k;
            assert (i == 0 == (k == 0));
            this.goUpWhileNeeded(p, dStack, eStack, ik, index);
            i = ik[0];
            k = ik[1];
            d = dStack[i - 1];
            this.e.copyFrom(eStack[i - 1]);
            boolean incremented = this.rBuffer[i - 1].increment();
            if (incremented) continue;
            assert (i == mMax);
            break;
        }
    }

    private BitVector[] allocateBitsForAllIterations() {
        int mMax = this.spec.maxBitsPerDimension();
        assert (mMax == this.masks.cardinalities().size());
        BitVector[] r = new BitVector[mMax];
        for (int i = 0; i < mMax; ++i) {
            r[i] = (BitVector)BitVectorFactories.OPTIMAL.apply(this.masks.getCardinality(i));
        }
        return r;
    }

    private void goUpWhileNeeded(BitVector[] p, int[] dStack, BitVector[] eStack, int[] ik, BitVector index) {
        int dimensionCount;
        int mMax = this.spec.maxBitsPerDimension();
        int i = ik[0];
        int k = ik[1];
        do {
            CompactHilbertCurve.clearOneBitInEachDimension(i, p);
            dimensionCount = this.masks.getCardinality(i);
            k += dimensionCount;
        } while (this.rBuffer[++i - 1].cardinality() == dimensionCount && i != mMax);
        index.clear(ik[1], k);
        ik[0] = i;
        ik[1] = k;
    }

    private static void computeInverseBits(int d, BitVector mu, BitVector e, BitVector r, BitVector[] wt) {
        BitVector w = wt[0];
        w.copyFrom(e);
        w.rotate(d);
        w.andNot(mu);
        BitVector t = wt[1];
        t.grayCodeRankInverse(mu, w, r);
        w.copyFrom(t);
        t.grayCode();
        t.rotate(-d);
        t.xor(e);
    }

    private static void computeCompactHilbertBits(int d, BitVector mu, BitVector e, BitVector w, BitVector r) {
        w.xor(e);
        w.rotate(d);
        w.grayCodeInverse();
        r.grayCodeRank(mu, w);
    }

    private static int updateD(int d, BitVector w) {
        d += w.lowestDifferentBit() + 1;
        return d %= w.size();
    }

    private static void updateE(int oldD, BitVector w, BitVector e) {
        w.smallerEvenAndGrayCode();
        w.rotate(-oldD);
        e.xor(w);
    }

    static void copyOneBitFromEachDimension(int i, BitVector[] p, BitVector bs) {
        int n;
        bs.clear();
        int j = n = p.length;
        while (--j >= 0) {
            BitVector bv = p[n - j - 1];
            if (i >= bv.size() || !bv.get(i)) continue;
            bs.set(j);
        }
    }

    static void clearOneBitInEachDimension(int i, BitVector[] p) {
        for (BitVector bv : p) {
            if (i >= bv.size()) continue;
            bv.clear(i);
        }
    }

    static void copyOneBitToEachDimensionWhereSet(BitVector src, int i, BitVector[] p) {
        int j;
        int n = p.length;
        int srcSize = src.size();
        int n2 = j = srcSize == 0 ? -1 : src.nextSetBit(0);
        while (j != -1) {
            p[n - j - 1].set(i);
            j = j == srcSize - 1 ? -1 : src.nextSetBit(j + 1);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

