## ----loadlib, echo = TRUE, results = 'hide', message=FALSE, warning=FALSE-----
library(KinformR)

show <- function(df){
  knitr::kable(df, format = "markdown", digits = 2)
}

## -----------------------------------------------------------------------------
example.pedigree.file <- system.file('extdata/example_pedigree_encoding.tsv',
                                     package = 'KinformR')

example.pedigree.df <- read.pedigree(example.pedigree.file)

## -----------------------------------------------------------------------------
colnames(example.pedigree.df)


## -----------------------------------------------------------------------------
show(example.pedigree.df)

## -----------------------------------------------------------------------------
penetrance.df <- score.pedigree(example.pedigree.df)

show(penetrance.df)


## -----------------------------------------------------------------------------
ord.df.current <- penetrance.df[order(penetrance.df$current.score, decreasing = TRUE),]
show(ord.df.current)


## -----------------------------------------------------------------------------
ord.df.max <- penetrance.df[order(penetrance.df$max.score, decreasing = TRUE),]
show(ord.df.max)


