/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import internal.text.base.api.TxtLegacyId;
import internal.text.base.api.TxtParam;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import jdplus.text.base.api.TxtBean;
import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.legacy.LegacyFileId;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

@DemetraPlusLegacy
public final class TxtLegacyMoniker
implements HasDataMoniker {
    private final String providerName;
    private final TxtParam param;

    @NonNull
    public TsMoniker toMoniker(@NonNull DataSource dataSource) throws IllegalArgumentException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        throw new IllegalArgumentException("Not supported yet.");
    }

    @NonNull
    public TsMoniker toMoniker(@NonNull DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        throw new IllegalArgumentException("Not supported yet.");
    }

    @NonNull
    public Optional<DataSource> toDataSource(@NonNull TsMoniker moniker) throws IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (TsMoniker)moniker);
        LegacyFileId id = LegacyFileId.parse((String)moniker.getId());
        return id != null ? Optional.of(this.toDataSource(Path.of(id.getFile(), new String[0]).toFile())) : Optional.empty();
    }

    @NonNull
    public Optional<DataSet> toDataSet(@NonNull TsMoniker moniker) throws IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (TsMoniker)moniker);
        TxtLegacyId id = TxtLegacyId.parse(moniker.getId());
        return id != null ? Optional.of(this.toDataSet(id)) : Optional.empty();
    }

    private DataSet toDataSet(TxtLegacyId id) {
        DataSource source = this.toDataSource(Path.of(id.getFile(), new String[0]).toFile());
        if (!id.isSeries()) {
            return DataSet.of((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION);
        }
        DataSet.Builder result = DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION);
        this.param.getSeriesParam().set(result, (Object)id.getSeriesIndex());
        return result.build();
    }

    private DataSource toDataSource(File file) {
        TxtBean bean = new TxtBean();
        bean.setFile(file);
        DataSource.Builder result = DataSource.builder((String)this.providerName, (String)this.param.getVersion());
        this.param.set(result, bean);
        return result.build();
    }

    @Generated
    private TxtLegacyMoniker(String providerName, TxtParam param) {
        this.providerName = providerName;
        this.param = param;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TxtLegacyMoniker of(String providerName, TxtParam param) {
        return new TxtLegacyMoniker(providerName, param);
    }
}

