/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;

public final class BooleanProperty
extends BaseProperty {
    @NonNull
    private final String key;
    private final boolean defaultValue;

    public boolean get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Boolean result = Parser.onBoolean().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public boolean get(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public boolean get(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, boolean value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onBoolean().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, boolean value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, boolean value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private BooleanProperty(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull BooleanProperty of(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new BooleanProperty(key, defaultValue);
    }

    @Override
    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean isDefaultValue() {
        return this.defaultValue;
    }
}

