#' @title  Simulate sample of idiosyncratic variances, sigma squared
#' @description  Simulate a sample of idiosyncratic variances, sigma squared from its posterior (inverse gamma)
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param hyp.parm  Hyperparameters generated by \code{initialize.hyp.parm}
#' @param parm  The whole parameters from current iteration
#'
#' @importFrom mvtnorm rmvnorm
#'
#' @return  A sample of sigma squared
#' @noRd

simulated.mu = function(model.attributes,hyp.parm, parm) {
  for(l in 1:model.attributes$G){
    n.assigned<-sum(parm$Z==l)
    if(n.assigned > 0){
      ind <- seq(1,model.attributes$S)[parm$Z[,1]==l]
      if(length(ind)>0){
        # len <- length(parm$X[seq(1,model.attributes$S)[parm$Z[,1]==l],,1])
        # ext.len <- len %% model.attributes$L
        # parm.X <- sample(parm$X[seq(1,model.attributes$S)[parm$Z[,1]==l],,1],(len+ext.len),replace=T)
        x.selected <- matrix(parm$X[seq(1,model.attributes$S)[parm$Z[,1]==l],,1],ncol=model.attributes$L)
      }else{
        x.selected <- c()
      }
      if(model.attributes$times > 1){
        for(tt in 2:model.attributes$times){
          ind <- seq(1,model.attributes$S)[parm$Z[,tt]==l]
          if(length(ind)>0){
            x.selected <- rbind(x.selected, matrix(parm$X[seq(1,model.attributes$S)[parm$Z[,tt]==l],,tt],ncol=model.attributes$L))
          }
        }
      }
    
      # update mu
      mu.solve = solve(hyp.parm$mu.C[l,,])
      omega.solve = solve(parm$omega[l,,])
      mu.C.star = solve(mu.solve + n.assigned*omega.solve)
      if(model.attributes$L > 1){
        mu.m.star = mu.C.star %*% (mu.solve%*%hyp.parm$mu.m[l,] + n.assigned*omega.solve%*%apply(x.selected,2,mean))
      }
      if(model.attributes$L == 1){
        mu.m.star = mu.C.star %*% (mu.solve%*%hyp.parm$mu.m[l,] + n.assigned*omega.solve%*%mean(x.selected))
      }
    }else{
      mu.C.star = hyp.parm$mu.C[l,,]
      mu.m.star = hyp.parm$mu.m[l,]
    }
    
    # parm$mu[l,] <- rmvnorm(1,mu.m.star,mu.C.star) CHANGE i made
    if(model.attributes$L>1){
      parm$mu[l,] <- rmvnorm(1,mu.m.star,mu.C.star)
    }else{
      parm$mu[l,] <- rnorm(1,mu.m.star,sqrt(mu.C.star))
    }
    
  }
  return(parm)
}

