% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{igft}
\alias{igft}
\title{Inverse Graph Fourier Transform}
\usage{
igft(fourier_coeffs, U)
}
\arguments{
\item{fourier_coeffs}{Input Fourier coefficients (vector or matrix)}

\item{U}{Matrix of eigenvectors (dense matrix preferred)}
}
\value{
Reconstructed signal in the vertex domain (vector or matrix)
}
\description{
Compute the Inverse Graph Fourier Transform (IGFT) of spectral coefficients using Laplacian eigenvectors.
}
\examples{
\donttest{
# Create example data
data <- data.frame(x = runif(50), y = runif(50), signal = rnorm(50))
SG <- initSGWT(data, signals = "signal")
SG <- runSpecGraph(SG, k = 10)
eigenvectors <- SG$Graph$eigenvectors

# Single signal - use GFT to get Fourier coefficients
fourier_coeffs <- gft(data$signal, eigenvectors)
signal_reconstructed <- igft(fourier_coeffs, eigenvectors)

# Multiple signals (batch processing)
signals_matrix <- cbind(data$signal, data$signal * 2)
fourier_coeffs_matrix <- gft(signals_matrix, eigenvectors)
signals_reconstructed <- igft(fourier_coeffs_matrix, eigenvectors)
}
}
