% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_main.R
\name{initSGWT}
\alias{initSGWT}
\title{Initialize SGWT object}
\usage{
initSGWT(
  data.in,
  x_col = "x",
  y_col = "y",
  signals = NULL,
  scales = NULL,
  J = 5,
  scaling_factor = 2,
  kernel_type = "heat"
)
}
\arguments{
\item{data.in}{Data frame containing spatial coordinates and signal data}

\item{x_col}{Character string specifying the column name for X coordinates (default: "x")}

\item{y_col}{Character string specifying the column name for Y coordinates (default: "y")}

\item{signals}{Character vector of signal column names to analyze. If NULL, all non-coordinate columns are used.}

\item{scales}{Vector of scales for the wavelets. If NULL, scales are auto-generated.}

\item{J}{Number of scales to generate if scales is NULL (default: 5)}

\item{scaling_factor}{Scaling factor between consecutive scales (default: 2)}

\item{kernel_type}{Kernel family ("mexican_hat", "meyer", or "heat") (default: "heat")}
}
\value{
SGWT object with Data and Parameters slots initialized
}
\description{
Build an SGWT object with Data and Parameters slots, validate inputs.
}
\examples{
\donttest{
# Initialize SGWT object
data <- data.frame(x = runif(100), y = runif(100), 
                  signal1 = rnorm(100), signal2 = rnorm(100))
SG <- initSGWT(data, signals = c("signal1", "signal2"))
}
}
