% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidateCohort.R
\name{getCohortValidationCounts}
\alias{getCohortValidationCounts}
\title{Validate cohort}
\usage{
getCohortValidationCounts(
  connectionDetails = NULL,
  connection = NULL,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema = cdmDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  cohortIds = NULL
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cdmDatabaseSchema}{Schema name where your patient-level data in OMOP CDM format resides.
Note that for SQL Server, this should include both the database and
schema name, for example 'cdm_data.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{cohortIds}{Ids of cohorts to validate}
}
\value{
a data.frame with the fields cohortId, overlappingErasCount, invalidDateCount, duplicateCount, outsideObservationCount
}
\description{
Using custom sql, it is possible to generate cohorts that are not technically definitions.
Invalid cohorts include the following:

* Cohorts where individuals have multiple, overlapping eras
* Cohorts that have start dates that occur after their end dates
* Cohorts with duplicate entries for the same subject.

Additionally the count for cohorts that lie outside the observation period for individuals is added. However,
due to valid reasons in cohort definitions (e.g. fixed cohort duration, data source context) this cannot be directly
considered a pass/fail diagnostic in all contexts.

Note - this code cannot formally verify the validity of a cohort. There may be situations where the logic of a
cohort definition only causes errors in certain circumstances. Furthermore, if cohort counts are 0 this check is
unable to evaluate validity at all.

The returned data.frame counts the number of errors found for each cohort. In addition a boolean "valid"
field is applied that is TRUE only in the case where all counts are 0.
}
