% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_recursion.R
\name{predictive_recursion}
\alias{predictive_recursion}
\title{Predictive recursion by Newton (2002)}
\usage{
predictive_recursion(x, k)
}
\arguments{
\item{x}{a sequence of chi-squared test statistics}

\item{k}{degrees of freedom}
}
\value{
a list: null proportion, prior probability, and lambda-mesh values
}
\description{
Predictive recursion by Newton (2002)
}
\examples{
set.seed(2021)
p = 1000
k = 7
# the prior distribution for lambda
alpha = 2
beta =  10
# lambda
lambda = rep(0, p)
pi_0 = 0
p_0 = floor(p*pi_0)
p_1 = p-p_0
lambda[(p_0+1):p] = stats::rgamma(p_1, shape = alpha, rate=1/beta)
# Generate a Poisson RV
J = sapply(1:p, function(x){rpois(1, lambda[x]/2)})
X = sapply(1:p, function(x){rchisq(1, k+2*J[x])})
out = predictive_recursion(X, k)

}
