% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecos.R
\name{ECOS_setup}
\alias{ECOS_setup}
\title{Set up an ECOS workspace for multi-step solving}
\usage{
ECOS_setup(
  c,
  G,
  h,
  dims = list(l = integer(0), q = NULL, e = integer(0)),
  A = NULL,
  b = numeric(0),
  control = ecos.control()
)
}
\arguments{
\item{c}{the coefficients of the objective function; the length of
this determines the number of variables \eqn{n} in the problem.}

\item{G}{the inequality constraint matrix in one of three forms: a
plain matrix, simple triplet matrix, or compressed column
format, e.g. \link[Matrix]{dgCMatrix-class}. Can also be
\code{NULL}}

\item{h}{the right hand side of the inequality constraint. Can be
empty numeric vector.}

\item{dims}{is a list of three named elements: \code{dims['l']} an
integer specifying the dimension of positive orthant cone,
\code{dims['q']} an integer vector specifying dimensions of
second-order cones, \code{dims['e']} an integer specifying the
number of exponential cones}

\item{A}{the optional equality constraint matrix in one of three
forms: a plain matrix, simple triplet matrix, or compressed
column format, e.g. \link[Matrix]{dgCMatrix-class}. Can be
\code{NULL}}

\item{b}{the right hand side of the equality constraint, must be
specified if \eqn{A} is. Can be empty numeric vector.}

\item{control}{is a named list that controls various optimization
parameters; see \link[ECOSolveR]{ecos.control}.}
}
\value{
an external pointer of class \code{"ecos_workspace"}.
  Must eventually be freed via \code{\link{ECOS_cleanup}} or R
  garbage collection.
}
\description{
Creates an ECOS workspace that can be solved, updated with new
numerical data, and solved again without repeating the expensive
symbolic analysis phase. This is useful for parametric optimization,
model predictive control, and other settings where the problem
structure stays the same but data changes.
}
\seealso{
\code{\link{ECOS_solve}}, \code{\link{ECOS_update}},
  \code{\link{ECOS_cleanup}}, \code{\link{ECOS_csolve}}
}
