% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eviews_pagesave.R
\name{eviews_pagesave}
\alias{eviews_pagesave}
\title{Save an \code{EViews} workfile page.}
\usage{
eviews_pagesave(
  wf = "",
  page = "",
  options = "",
  source_description = "",
  table_description = "",
  keep_list = "",
  drop_list = "",
  keepmap_list = "",
  dropmap_list = "",
  smpl_spec = "",
  save_path = dirname(source_description)
)
}
\arguments{
\item{wf}{Object or a character string representing the name of an \code{EViews} workfile.}

\item{page}{Object or a character string representing the name of an \code{EViews} workfile page.}

\item{options}{Object or a character string of any of the acceptable \code{EViews} \code{pagesave} options, such as \code{noid}, \code{nomapval}, \code{nonames}.}

\item{source_description}{The path and name of the file to be saved.}

\item{table_description}{Further description of the \code{source_description} such as specifying the \code{range=arg}, \code{byrow}.}

\item{keep_list}{Optional. Specify the list of \code{EViews} object to be saved.}

\item{drop_list}{Optional. Specify the list of \code{EViews} object to be dropped.}

\item{keepmap_list}{Optional. Specify the list of patterns of \code{EViews} object to be saved.}

\item{dropmap_list}{Optional. Specify the list of patterns of \code{EViews} object to be dropped.}

\item{smpl_spec}{Optional. Specify the \code{EViews} sample string}

\item{save_path}{Object or a character string representing the path to the folder to save the \code{EViews} graphs. The current working directory is the default \code{save_path}. Specify the \code{save_path} only if you want the \code{EViews} graphs to live in different path from the current working directory.}
}
\value{
An EViews workfile.
}
\description{
Use this function in  R, R Markdown and Quarto to save an \code{EViews} workfile page.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

eviews_pagesave(wf="exec_commands",source_description = "eviews_pagesave.csv",
drop_list = "y")
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
