% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_initial_self.R
\name{design_initial_self}
\alias{design_initial_self}
\title{function to generate initial design with design points and the approximate allocation}
\usage{
design_initial_self(
  k.continuous,
  factor.level,
  MLM,
  xlist_fix = NULL,
  lvec,
  uvec,
  bvec,
  h.func,
  link = "continuation",
  Fi.func = Fi_MLM_func,
  delta0 = 1e-06,
  epsilon = 1e-12,
  maxit = 1000
)
}
\arguments{
\item{k.continuous}{number of continuous variables}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{MLM}{TRUE or FALSE, TRUE: generate initial design for multinomial logistic model, FALSE: generate initial design for generalized linear model}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{lvec}{lower limit of continuous variables}

\item{uvec}{upper limit of continuous variables}

\item{bvec}{assumed parameter values of beta}

\item{h.func}{function for generating the corresponding model matrix or predictor vector, given an experimental setting or design point.}

\item{link}{link function, default "continuation", other options "baseline", "adjacent" and "cumulative"}

\item{Fi.func}{function, is used to calculate Fisher inforamtion for a design point, default to be Fi_MLM_func() in the package}

\item{delta0}{tuning parameter, the distance threshold, || x_i(0) - x_j(0) || >= delta0}

\item{epsilon}{tuning parameter as converging threshold, such that, a nonnegative number is regarded as numerical zero if less than epsilon, default 1e-12.}

\item{maxit}{maximum number of iterations}
}
\value{
X      matrix of initial design point

p0     initial random approximate allocation

f.det  the determinant of Fisher information matrix for the initial design
}
\description{
function to generate initial design with design points and the approximate allocation
}
\examples{
k.continuous.temp=5
link.temp = "cumulative"
n.factor.temp = c(0,0,0,0,0,2)  # 1 discrete factor w/ 2 levels + 5 continuous
## Note: Always put continuous factors ahead of discrete factors,
## pay attention to the order of coefficients paring with predictors
lvec.temp = c(-25,-200,-150,-100,0,-1)
uvec.temp = c(25,200,0,0,16,1)
hfunc.temp = function(y){
if(length(y) != 6){stop("Input should have length 6");}
 model.mat = matrix(NA, nrow=5, ncol=10, byrow=TRUE)
 model.mat[5,]=0
 model.mat[1:4,1:4] = diag(4)
 model.mat[1:4, 5] =((-1)*y[6])
 model.mat[1:4, 6:10] = matrix(((-1)*y[1:5]), nrow=4, ncol=5, byrow=TRUE)
 return(model.mat)
 }
bvec.temp=c(-1.77994301, -0.05287782,  1.86852211, 2.76330779, -0.94437464, 0.18504420,
-0.01638597, -0.03543202, -0.07060306, 0.10347917)

design_initial_self(k.continuous=k.continuous.temp, factor.level=n.factor.temp,
MLM=TRUE,xlist_fix=NULL, lvec=lvec.temp,uvec=uvec.temp, bvec=bvec.temp,
h.func=hfunc.temp,link=link.temp)


}
