% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_get_tool_id}
\alias{galaxy_get_tool_id}
\title{Retrieve Galaxy tool IDs by name}
\usage{
galaxy_get_tool_id(
  name,
  tools = NULL,
  ignore_case = TRUE,
  galaxy_url = "https://usegalaxy.eu",
  panel_id = NULL
)
}
\arguments{
\item{name}{Character string to search for in tool names.}

\item{tools}{Optional list as returned by \code{galaxy_list_tools}.
If \code{NULL}, the function will fetch tools on the fly by calling
\code{galaxy_list_tools}.}

\item{ignore_case}{Logical. Whether matching should ignore case.
Default: \code{TRUE}.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}

\item{panel_id}{Optional character. Passed through to
\code{galaxy_list_tools} when \code{tools} is \code{NULL} so you can
restrict the search to a panel/section.}
}
\value{
Character vector of matching tool IDs in decreasing order (usually highest version first). Returns \code{character(0)}
if no tools match.
}
\description{
Retrieve Galaxy tool IDs by name
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}

# Fetch the full tool list once, then lookup
tools <- galaxy_list_tools()
galaxy_get_tool_id("FastQC", tools = tools)

# Or let the helper fetch on demand
galaxy_get_tool_id("FastQC")

# Exact, case-sensitive match inside a specific panel
galaxy_get_tool_id("Concatenate datasets",
ignore_case = FALSE, panel_id = "Text Manipulation")

\dontshow{\}) # examplesIf}
}
