% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_upload_https}
\alias{galaxy_upload_https}
\alias{galaxy_upload_https,character-method}
\alias{galaxy_upload_https,Galaxy-method}
\title{Generic upload file with https}
\usage{
galaxy_upload_https(
  x,
  input_file,
  wait = FALSE,
  wait_timeout = 600,
  galaxy_url = "https://usegalaxy.eu",
  file_type = "auto",
  dbkey = "?",
  ...
)

\S4method{galaxy_upload_https}{character}(
  x,
  input_file,
  wait = FALSE,
  wait_timeout = 600,
  galaxy_url = "https://usegalaxy.eu",
  file_type = "auto",
  dbkey = "?",
  ...
)

\S4method{galaxy_upload_https}{Galaxy}(
  x,
  input_file,
  wait = FALSE,
  wait_timeout = 600,
  galaxy_url = "https://usegalaxy.eu",
  file_type = "auto",
  dbkey = "?",
  ...
)
}
\arguments{
\item{x}{A \code{Galaxy} object, or a \code{history_id} to use the default method.}

\item{input_file}{Path to the local file to upload.}

\item{wait}{Logical. Whether to wait for Galaxy to finish processing.}

\item{wait_timeout}{Time in seconds until \code{wait} times out with an error.}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the default method.
If \code{GALAXY_URL} is set it takes precedence.}

\item{file_type}{Galaxy datatype identifier (e.g. \code{"auto"}, \code{"fastq"}, \code{"bam"}).}

\item{dbkey}{Reference genome identifier (e.g. \code{"?"} or \code{"hg38"}).}

\item{...}{not in use}
}
\value{
For the default method, a character scalar dataset ID. For the
\code{Galaxy} method, the modified \code{Galaxy} object.
}
\description{
\code{galaxy_upload_https()} is an S4 generic. With no \code{x} supplied it uploads a
local file via HTTPS to the specified history and returns the encoded dataset
ID. When called with a \code{Galaxy} object it uses the object's \code{history_id} and
\code{galaxy_url}, uploads the file, and updates the object with the new
\code{input_dataset_id}.
}
\details{
This uses Galaxy's built‑in \code{upload1} tool and performs a multipart form
POST. Large files may still require FTP depending on server configuration.
A valid API key (\code{GALAXY_API_KEY}) must be available in the environment.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
hid <- galaxy_initialize("test upload")
test_file <- tempfile(fileext = ".txt")
writeLines("This is an example test file.", test_file)
file_id <- galaxy_upload_https(hid, test_file)
g <- galaxy()
g <- galaxy_initialize(g)
g <- galaxy_upload_https(g, test_file)
\dontshow{\}) # examplesIf}
}
