% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_diff_uptake_data.R
\name{show_p_diff_uptake_data}
\alias{show_p_diff_uptake_data}
\title{Differential deuterium uptake data}
\usage{
show_p_diff_uptake_data(
  p_diff_uptake_dat,
  theoretical = FALSE,
  fractional = FALSE,
  renamed = TRUE
)
}
\arguments{
\item{p_diff_uptake_dat}{data produced by 
\code{\link{create_p_diff_uptake_dataset}} function}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{renamed}{\code{logical}, indicator if the names of the columns
are renamed to user-friendly ones. Currently FALSE not implemented.}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Present differential deuterium uptake values 
in selected form
}
\details{
The function \code{\link{show_uptake_data}} generates a subsets
of the diff_uptake_dat based on selected parameters.
The numerical values are rounded to 4 places. The names of columns
are changed to user-friendly ones.
}
\examples{
p_diff_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
head(show_p_diff_uptake_data(p_diff_uptake_dat))

}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_diff_uptake_dataset}}
}
