% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlayDensities.R
\name{iscamaddtnorm}
\alias{iscamaddtnorm}
\title{Overlay a t Density Function and a Normal Density Function on Histogram}
\usage{
iscamaddtnorm(
  x,
  df,
  main = "Histogram with t and normal curve",
  xlab = deparse(substitute(x)),
  bins = NULL
)
}
\arguments{
\item{x}{A numeric vector representing the data to be plotted.}

\item{df}{A numeric value representing the degrees of freedom of \code{x}.}

\item{main}{(optional) title for the plot.}

\item{xlab}{(optional) x-axis label for the plot.}

\item{bins}{(optional) number of bins for the histogram.}
}
\value{
A histogram of x overlayed with an t density function and a normal density function.
}
\description{
Overlay a t Density Function and a Normal Density Function on Histogram
}
\examples{
set.seed(0)
x <- rt(100, 5)
iscamaddtnorm(x, 5)
iscamaddtnorm(x, 5, main = "Your Active Title", xlab = "t Data", bins = 20)
}
