% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.var.table}
\alias{read.var.table}
\title{Read in a vcf-like subset of information obtained from
use of seqbiopy's vcf_extract function on a vcf with the
status encoded in the indivudal's names}
\usage{
read.var.table(fname)
}
\arguments{
\item{fname}{A file name, expected format of contents is:
#CHROM  POS       REF  ALT  MS-5678-1001_A  MS-5678-1002_U  ...
chr3    46203838  G    A    0/1             0/0      ...}
}
\value{
A dataframe.
Data will be worked into a data frame with format.
name	         status	variant
MS-5678-1001      A      0/1
}
\description{
Note - ensure the status in the names match your desired encoding!
There are individuals with ambiguous statues, that you may require to
be encoded in a specific fashion for you current purposes.
}
\examples{
ex.infile <-system.file('extdata/example_vcf_extract_5678.tsv',
                         package = 'KinformR')
read.var.table(ex.infile)
}
