\name{Randompartition_function}
\alias{Randompartition_function}
\title{
Generate a Random Partition Matrix of Equally sized row and column clusters. These clusters are mutually exclusive and there is no empty row and column cluster.
}
\description{
Generates a binary matrix representing a random partition of \code{i} items into \code{p} latent groups. Each row indicates group membership in a one-hot encoded format.
}
\usage{
Randompartition_function(i, p)
}
\arguments{
  \item{i}{
An integer specifying the total number of rows or columns of a data matrix to be partitioned.
}
  \item{p}{
An integer specifying the number of latent row or column clusters. 
}
}
\details{
This function creates a binary matrix of size \code{i x p}, where each row corresponds to a row cluster. The function first ensures that each cluster has at least one initial 
member (by using an identity matrix), and then assigns the remaining items randomly to clusters. Finally, the matrix rows are shuffled to ensure randomization of the assignment order.
}
\value{
A binary matrix of dimensions \code{i x p}:
  \item{A}{A binary matrix indicating the membership of each row to one of the \code{p} row clusters. Each row has exactly one 1 indicating cluster membership.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is primarily used for generating initial row or column cluster membership matrices in the REMAXINT and E-ReMI methods.
}
\seealso{
\code{\link{REMAXINT}, \link{E_ReMI}, \link{diag}}
}
\examples{
result <- Randompartition_function(i = 10, p = 3)
result
}
\keyword{REMAXINT and E-ReMI based two-mode clustering}
\keyword{random partition matrix}
