% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPerson.R
\name{plotPerson}
\alias{plotPerson}
\title{Visualise the output of \code{summarisePerson()}}
\usage{
plotPerson(result, variableName = NULL, style = NULL, type = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of \code{summarisePerson()}).}

\item{variableName}{The variable to plot, a choice between
\code{unique(result$variable_name)}. If \code{NULL} it will only work if only one
variable is present in the result object.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character,
this may be either the name of a built-in style (see
\code{visOmopResults::plotStyle()}), or a path to a .yml file that defines a
custom style. If \code{NULL}, the function will use the explicit default style,
unless a global style option is set (see \code{visOmopResults::setGlobalPlotOptions()})
or a _brand.yml file is present (in that order).}

\item{type}{Character string indicating the output plot format. See
\code{visOmopResults::plotType()} for the list of supported plot types. If
\code{type = NULL}, the function will use the global setting defined via
\code{visOmopResults::setGlobalPlotOptions()} (if available); otherwise, a
standard \code{ggplot2} plot is produced by default.}
}
\value{
A plot visualisation.
}
\description{
Visualise the output of \code{summarisePerson()}
}
\examples{
\donttest{
library(OmopSketch)
library(dplyr, warn.conflicts = FALSE)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summarisePerson(cdm = cdm)

tablePerson(result = result)

cdmDisconnect(cdm = cdm)
}

}
