% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{qq_colorscales}
\alias{qq_colorscales}
\title{Available Color Scales for QQ Regression Plots}
\usage{
qq_colorscales(show_preview = TRUE)
}
\arguments{
\item{show_preview}{Logical. If \code{TRUE}, prints information about
each color scale. Default is \code{TRUE}.}
}
\value{
A character vector of available color scale names, invisibly.
}
\description{
Returns information about the available color scales for 3D surface plots
and heatmaps in the QuantileOnQuantile package.
}
\details{
The following color scales are available:
\describe{
  \item{Jet}{MATLAB-style rainbow colorscale. Transitions from blue
    through cyan, green, yellow to red. Best for general visualization
    where the full range of values is important.}
  \item{BlueRed}{Diverging colorscale from blue to red. Also known as
    "COVID style" in some contexts. Best for data with a meaningful
    center point (e.g., zero for coefficients).}
  \item{Viridis}{Perceptually uniform colorscale. Designed to be
    colorblind-friendly and print well in grayscale.}
  \item{Plasma}{Another perceptually uniform colorscale. Similar
    benefits to Viridis but with a different color palette.}
}
}
\examples{
# Show available color scales
qq_colorscales()

# Get scales without printing
scales <- qq_colorscales(show_preview = FALSE)
print(scales)

}
