% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{economic_cycles}
\alias{economic_cycles}
\title{Economic Cycles Dataset}
\format{
A time series object of length 500 with attributes:
\describe{
\item{true_changepoints}{Vector of true changepoint locations: c(120, 250, 380)}
\item{description}{Description of the dataset}
\item{regimes}{Names of the regimes: Expansion, Recession, Recovery, Stable Growth}
}
}
\source{
Simulated data for package examples
}
\usage{
economic_cycles
}
\description{
A simulated time series representing an economic indicator with regime changes
corresponding to expansion, recession, recovery, and stable growth periods.
}
\details{
The data simulates monthly economic data from 2000-2041 with four distinct regimes:
\itemize{
\item Regime 1 (1-120): Expansion - positive trend, low volatility
\item Regime 2 (121-250): Recession - negative trend, high volatility
\item Regime 3 (251-380): Recovery - positive trend, medium volatility
\item Regime 4 (381-500): Stable Growth - low trend, low volatility
}
}
\examples{
\donttest{
data(economic_cycles)
result <- detect_regimes(economic_cycles, method = "pelt")
plot(result)

# Compare with true changepoints
true_cps <- attr(economic_cycles, "true_changepoints")
evaluate(result, true_changepoints = true_cps)
}
}
\keyword{datasets}
