% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_deeplearning.R
\name{transformer_detect}
\alias{transformer_detect}
\title{Transformer-based Changepoint Detection}
\usage{
transformer_detect(
  data,
  true_changepoints = NULL,
  window_size = 128,
  d_model = 64,
  n_heads = 4,
  n_layers = 2,
  d_ff = 256,
  dropout = 0.1,
  epochs = 50,
  threshold = 0.5,
  verbose = FALSE
)
}
\arguments{
\item{data}{Numeric vector of time series data}

\item{true_changepoints}{Optional vector of known changepoints}

\item{window_size}{Input window size (default: 128)}

\item{d_model}{Model dimension (default: 64)}

\item{n_heads}{Number of attention heads (default: 4)}

\item{n_layers}{Number of transformer layers (default: 2)}

\item{d_ff}{Feed-forward dimension (default: 256)}

\item{dropout}{Dropout rate (default: 0.1)}

\item{epochs}{Training epochs (default: 50)}

\item{threshold}{Detection threshold (default: 0.5)}

\item{verbose}{Show progress (default: FALSE)}
}
\value{
List with changepoints, attention weights, and model
}
\description{
Implements a transformer architecture inspired by TCDformer for
time series changepoint detection using self-attention mechanisms.
}
\references{
Wu, H., et al. (2023). TimesNet: Temporal 2D-Variation Modeling

Zhou, H., et al. (2021). Informer: Efficient Transformer for Long
Sequence Time-Series Forecasting
}
