% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{world}
\alias{world}
\title{World Countries}
\format{
A \code{PackedSpatVector} object with country polygons and one attribute:
\describe{
\item{name}{Country name.}
}
}
\source{
Natural Earth data, via \strong{rnaturalearthdata}.
}
\usage{
world
}
\description{
A \code{"PackedSpatVector"} containing country polygons from \strong{Natural Earth},
processed and cleaned for use within the package. Country names were
converted to lowercase and had accents removed.
}
\details{
The dataset is sourced from \code{rnaturalearthdata::map_units110}, then:
\itemize{
\item converted to a \code{SpatVector} using \strong{terra},
\item attribute \code{"name"} cleaned (\code{tolower()}, \code{remove_accent()}),
\item wrapped using \code{terra::wrap()} for robust internal storage.
}
}
\examples{
data(world)
world <- terra::unwrap(world)
terra::plot(world)
}
\keyword{datasets}
